<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_CacheFileinclude.php,v 1.2 2007/05/08 15:55:06 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * t@CLbVNX
 */
require_once 'SyL_CacheFile.php';

/**
 * CN[ht@CLbVNX
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_CacheFileinclude.php,v 1.2 2007/05/08 15:55:06 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_CacheFileinclude extends SyL_CacheFile
{
    /**
     * RXgN^
     *
     * @access public
     */
    function SyL_CacheFileinclude()
    {
        $this->setCrc(false);
        $this->setSerialize(false);
    }

    /**
     * LbVǂݍ
     *
     * @access public
     * @param bool LbVLԂXV
     * @param int ŒXViUNIX timej
     * @return mixed LbVf[^
     */
    function read($modify_time_update=false, $mtime=0)
    {
        $filename = $this->getFileName();
        if (file_exists($filename)) {
            // LbVt@COK
            $mtime_tmp = filemtime($filename);
            if ($mtime && $mtime_tmp < $mtime) {
                return false;
            }
            // LԂ擾
            $life_time = is_numeric($this->life_time) ? $mtime_tmp + $this->life_time : null;

            if (($life_time === null) || ($life_time >= time())) {
                $data = include $filename;
                if ($modify_time_update) {
                    $this->setModifyTime();
                }
                return $data;
            } else {
                // LbVLԐ؂
                $this->delete();
                return false;
            }
        } else {
            // LbVt@C
            return false;
        }
    }

    /**
     * LbVۑ
     *
     * @access public
     * @param mixed LbVf[^
     * @return bool true: ۑAfalse: ۑG[
     */
    function write($data)
    {
        $data = trim($data);
        if (substr($data, 0, 2) != '<?') {
            $data = "<?php\n" . $data;
        }
        if (substr($data, -2) != '?>') {
            $data .= "\n?>\n";
        }
        return parent::write($data);
    }

}

?>
