<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigDefines.php,v 1.14 2007/05/15 15:36:58 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եɤ߹ߡ륯饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigDefines.php,v 1.14 2007/05/15 15:36:58 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ConfigDefines extends SyL_Config
{
    /**
     * å
     * 
     * @access private
     * @var string
     */
    var $cache = '';

    /**
     * XMLեβϽ
     *
     * @access public
     */
    function parseXml()
    {
        if (SYL_PROJECT_CACHE_DIR) {
            // åѤ
            $cache =& $this->getCacheObject(SYL_PROJECT_CACHE_DIR . 'defines');
            if ($cache) {
                parent::parseXml();
                $cache->write($this->getCache());
            }
        } else {
            // åѤʤ
            parent::parseXml();
        }
    }

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access public
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        if ($current_path == '/syl-defines/define') {
            if (defined($attribute['name'])) {
                // Ѥߤϥå
                return;
            }
            $value = $this->readDefine($attribute['name'], $text);
            $def   = "define('{$attribute['name']}', \"{$value}\");";
            $this->cache .= $def . "\n";
            eval($def);
        }
    }

    /**
     * ɤ߹
     *
     * @access public
     * @param string ե̾
     * @param object ȥ饪֥
     */
    function readDefine($name, $value)
    {
        $value = " {$value} ";
        $value = preg_replace_callback('/(.+)\{([^\}]+)\}(.+)/', array(&$this, 'replaceConstant'), $value, 1);
        $value = substr($value, 1, -1);
        return $value;
    }

    /**
     * ֤Хå᥽å
     *
     * @access public
     * @param array ޥå
     @ return mixed ޥå
     */
    function replaceConstant($matches)
    {
        $matches = str_replace('"', '\\"', $matches);
        return $matches[1] . '".' . $matches[2] . '."' . $matches[3];
    }

    /**
     * ꥭå
     * 
     * @access public
     * @return string ꥭå
     */
    function getCache()
    {
        return $this->cache;
    }
}

?>
