<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DataXmlrpc.php,v 1.3 2007/05/08 15:55:06 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XMLRPCꥯȥѡ饹
 */
require_once SYL_INCLUDE_DIR . '/lib/Xml/Rpc/SyL_XmlRpcServerReader.php';

/**
 * XMLRPCꥯȥǡݻ饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DataXmlrpc.php,v 1.3 2007/05/08 15:55:06 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DataXmlrpc extends SyL_Data
{
    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_DataXmlrpc()
    {
        $xml = null;
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $xml = file_get_contents('php://input');
        }

        if (!$xml) {
            trigger_error("[SyL error] XMLRPC POST data not found.", E_USER_ERROR);
        }

        $reader =& new SyL_XmlRpcServerReader();
        $reader->setXmlEncode(SYL_ENCODE_XMLRPC);
        $reader->setData($xml);
        $reader->parseXml();

        $parameters = $reader->getArgs();
        array_unshift($parameters, $reader->getMethod());
        $this->setInputParameters($parameters);
    }
}

?>
