<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorXmlrpc.php,v 1.2 2007/04/30 13:15:57 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XMLRPCϥ顼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorXmlrpc.php,v 1.2 2007/04/30 13:15:57 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ErrorXmlrpc extends SyL_Error
{
    /**
     * Ķ̥顼
     * 
     * @access public
     * @param array 顼å
     * @param array 顼ȥ졼
     */
    function displayError($error_messages, $error_trace)
    {
        if (!ini_get('display_errors')) {
            return;
        }

        // XMLRPCꥯȥѡ饹
        include_once SYL_INCLUDE_DIR . '/lib/Xml/Rpc/SyL_XmlRpcBuilderServer.php';

        $builder =& new SyL_XmlRpcBuilderServer();
        // 顼No򥻥å
        $builder->setErrorCode($this->controller->getErrorNo());
        // 顼å򥻥å
        $builder->setErrorMessage(implode($this->eof, $error_messages));
        // 󥳡ǥ󥰤򥻥å
        $builder->setEncoding(SYL_ENCODE_XMLRPC);

         // ƥĥ
        $content_type = 'text/xml; charset=' . SYL_ENCODE_XMLRPC;
        SyL_Response::setHeader('Content-Type', $content_type);
        $response =& SyL_Response::getInstance();
        $response->display($builder->build());
    }

}

?>
