<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_SqlColumnData.php,v 1.2 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * SQLǡ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_SqlColumnData.php,v 1.2 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_SqlColumnData
{
    /**
     * ֥
     *
     * @access private
     * @var object
     */
    var $column = null;
    /**
     * ǡ
     *
     * @access private
     * @var mixed
     */
    var $data = null;
    /**
     * ڥ졼
     *
     * @access private
     * @var string
     */
    var $operator = '=';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param object ४֥
     * @param string ǡ
     * @param string ڥ졼
     */
    function SyL_SqlColumnData(&$column, $data, $operator='=')
    {
        $this->column   =& $column;
        $this->data     = $data;
        $this->operator = $operator;
    }

    /**
     * ǡ
     *
     * @access public
     * @return string ǡ
     */
    function getData()
    {
        return $this->data;
    }

    /**
     * Ȥ줿ǡ
     *
     * @access public
     * @return string Ȥ줿ǡ
     */
    function getQuoteData()
    {
        return $this->column->table->conn->quote($this->getData());
    }

    /**
     * ѥ᡼ͤˤꥯȤʸ
     * ˥¹Ԥ
     *
     * @access public
     * @param string ʸ
     * @return string ȸʸ
     */
    function quote($value)
    {
        return $this->column->table->conn->quote($value);
    }

    /**
     * 
     *
     * @access public
     * @return string where
     */
    function getFormat()
    {
        $operator = strtoupper($this->operator);
        switch ($operator) {
        case '=':  return $this->getFormatEqual(true);
        case '!=':
        case '<>': return $this->getFormatEqual(false);
        case 'NULL':
        case 'IS NULL': return $this->getFormatNull(true);
        case 'NOT NULL':
        case 'IS NOT NULL': return $this->getFormatNull(false);
        case 'LIKE':        return $this->getFormatLike(true);
        case 'NOT LIKE':    return $this->getFormatLike(false);
        case 'IN':          return $this->getFormatIn(true);
        case 'NOT IN':      return $this->getFormatIn(false);
        case 'BETWEEN':     return $this->getFormatBetween();
        default:
            trigger_error("[SyL error] Not supported operator ({$operator})", E_USER_ERROR);
        }
    }

    /**
     * whereӡ
     *
     * @access public
     * @param string true: =, false: <>
     * @return string where
     */
    function getFormatEqual($equal=true)
    {
        $name = $this->column->getNameWhere();
        $op = ($equal) ? '=' : '<>';
        if (is_object($this->data)) {
            $value = $this->data->getNameWhere();
        } else {
            $value = $this->quote($this->data);
        }
        return "{$name} {$op} {$value}";
    }

    /**
     * whereNULLӡ
     *
     * @access public
     * @param string true: IS NULL, false: IS NOT NULL
     * @return string where
     */
    function getFormatNull($equal=true)
    {
        $name = $this->column->getNameWhere();
        $op = ($equal) ? 'IS NULL' : 'IS NOT NULL';
        if (is_object($this->data)) {
            $value = $this->data->getNameWhere();
        } else {
            $value = $this->quote($this->data);
        }
        return "{$name} {$op}";
    }

    /**
     * whereLIKEӡ
     *
     * @access public
     * @param string true: LIKE, false: NOT LIKE
     * @return string where
     */
    function getFormatLike($equal=true)
    {
        $name = $this->column->getNameWhere();
        $op = ($equal) ? 'LIKE' : 'NOT LIKE';
        if (is_object($this->data)) {
            $value = $this->data->getNameWhere();
        } else {
            $value = (string)$this->data;
            $value = $this->quote($value);
        }
        return "{$name} {$op} {$value}";
    }

    /**
     * whereINӡ
     *
     * @access public
     * @param string true: IN, false: NOT IN
     * @return string where
     */
    function getFormatIn($equal=true)
    {
        $name = $this->column->getNameWhere();
        $op = ($equal) ? 'IN' : 'NOT IN';
        if (is_array($this->data)) {
            $value = implode(',', array_map(array(&$this, 'quote'), $this->data));
        } else {
            $value = $this->quote($this->data);
        }
        return "{$name} {$op} ({$value})";
    }

    /**
     * whereBETWEENӡ
     *
     * @access public
     * @return string where
     */
    function getFormatBetween()
    {
        $name = $this->column->getNameWhere();
        $value1 = '';
        $value2 = '';
        if (is_array($this->data) && (count($this->data) == 2)) {
            if (is_object($this->data[0])) {
                $value1 = $this->data[0]->getNameWhere();
            } else {
                $value1 = $this->quote($this->data[0]);
            }
            if (is_object($this->data[1])) {
                $value2 = $this->data[1]->getNameWhere();
            } else {
                $value2 = $this->quote($this->data[1]);
            }

        } else {
            trigger_error("[SyL error] Invalid Between value", E_USER_ERROR);
        }
        return "{$name} BETWEEN {$value1} AND {$value2}";
    }
}

?>
