<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssReaderAtom1_0.php,v 1.1 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * Atom 1.0꡼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssReaderAtom1_0.php,v 1.1 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlRssReaderAtom1_0 extends SyL_XmlRssReader
{
    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $index = 0;

        // XMLϷ̤
        switch ($current_path) {
        // -------------------------------------------------
        // إå
        // -------------------------------------------------
        case '/feed/rights':
            $this->channel['rights']    = $text;
            $this->channel['copyright'] = $text;
            if (isset($attribute['type'])) {
                $this->channel_attr['rights']['type']    = $attribute['type'];
                $this->channel_attr['copyright']['type'] = $attribute['type'];
            }
            break;
        case '/feed/dc:language':
            $this->channel['dc:language'] = $text;
            $this->channel['language']    = $text;
            break;
        case '/feed/link':
            if (!isset($this->channel_attr['link'])) {
                $this->channel_attr['link']  = array();
                $this->channel_attr['links'] = array();
            }
            $i = count($this->channel_attr['links']);

            if (isset($attribute['href']))     $this->channel_attr['links'][$i]['href']     = $attribute['href'];
            if (isset($attribute['rel']))      $this->channel_attr['links'][$i]['rel']      = $attribute['rel'];
            if (isset($attribute['type']))     $this->channel_attr['links'][$i]['type']     = $attribute['type'];
            if (isset($attribute['hreflang'])) $this->channel_attr['links'][$i]['hreflang'] = $attribute['hreflang'];
            if (isset($attribute['title']))    $this->channel_attr['links'][$i]['title']    = $attribute['title'];
            if (isset($attribute['length']))   $this->channel_attr['links'][$i]['length']   = $attribute['length'];
            if ($i == 0) $this->channel_attr['link'] = $this->channel_attr['links'][$i];
            break;
        case '/feed/updated':
            $this->channel['updated'] = $text;
            $this->channel['date']    = $this->convertDateTime($text);
            break;
        case '/feed/title':
            $this->channel['title'] = $text;
            if (isset($attribute['type'])) $this->channel_attr['title']['type'] = $attribute['type'];
            break;
        case '/feed/contributor':
            if (!isset($this->channel['contributor'])) {
                $this->channel['contributor']  = array();
                $this->channel['contributors'] = array();
            }
            $index = count($this->channel['contributors']);
            break;
        case '/feed/contributor/name':
            $this->channel['contributors'][$index]['name'] = $text;
            if ($index == 0) $this->channel['contributor']['name'] = $text;
            break;
        case '/feed/contributor/uri':
            $this->channel['contributors'][$index]['uri'] = $text;
            if ($index == 0) $this->channel['contributor']['uri'] = $text;
            break;
        case '/feed/contributor/email':
            $this->channel['contributors'][$index]['email'] = $text;
            if ($index == 0) $this->channel['contributor']['email'] = $text;
            break;
        case '/feed/category':
            if (!isset($this->channel_attr['category'])) {
                $this->channel_attr['category']   = array();
                $this->channel_attr['categories'] = array();
            }
            $i = count($this->channel_attr['categories']);

            if (isset($attribute['term']))   $this->channel_attr['categories'][$i]['term']   = $attribute['term'];
            if (isset($attribute['scheme'])) $this->channel_attr['categories'][$i]['scheme'] = $attribute['scheme'];
            if (isset($attribute['label']))  $this->channel_attr['categories'][$i]['label']  = $attribute['label'];
            if ($i == 0) $this->channel_attr['category'] = $this->channel_attr['categories'][$i];
            break;
        case '/feed/generator':
            $this->channel['generator'] = $text;
            if (isset($attribute['uri']))     $this->channel_attr['generator']['uri']     = $attribute['uri'];
            if (isset($attribute['version'])) $this->channel_attr['generator']['version'] = $attribute['version'];
            break;
        case '/feed/author':
            if (!isset($this->channel['author'])) {
                $this->channel['author']  = array();
                $this->channel['authors'] = array();
            }
            $index = count($this->channel['authors']);
            break;
        case '/feed/author/name':
            $this->channel['authors'][$index]['name'] = $text;
            if ($index == 0) $this->channel['author']['name'] = $text;
            break;
        case '/feed/author/uri':
            $this->channel['authors'][$index]['uri'] = $text;
            if ($index == 0) $this->channel['author']['uri'] = $text;
            break;
        case '/feed/author/email':
            $this->channel['authors'][$index]['email'] = $text;
            if ($index == 0) $this->channel['author']['email'] = $text;
            break;
        case '/feed/icon': $this->channel['icon'] = $text; break;
        case '/feed/id':   $this->channel['id']   = $text; break;
        case '/feed/subtitle':
            $this->channel['subtitle'] = $text;
            if (isset($attribute['type'])) $this->channel_attr['subtitle']['type'] = $attribute['type'];
            break;
        case '/feed/logo': $this->channel['logo'] = $text; break;

        // -------------------------------------------------
        // ǡ
        // -------------------------------------------------
        // RSS
        case '/feed/entry':
            $this->items[]    = array();
            $this->item_count = count($this->items);
            break;
        case '/feed/entry/content':
            $this->items[$this->item_count-1]['content']     = $text;
            $this->items[$this->item_count-1]['description'] = $text;
            if (isset($attribute['type'])) {
                $this->items_attr[$this->item_count-1]['content']['type']     = $attribute['type'];
                $this->items_attr[$this->item_count-1]['description']['type'] = $attribute['type'];
            }
            if (isset($attribute['src'])) {
                $this->items_attr[$this->item_count-1]['content']['src']     = $attribute['src'];
                $this->items_attr[$this->item_count-1]['description']['src'] = $attribute['src'];
            }
            break;
        case '/feed/entry/link':
            if (!isset($this->items_attr[$this->item_count-1]['link'])) {
                $this->items_attr[$this->item_count-1]['link']  = array();
                $this->items_attr[$this->item_count-1]['links'] = array();
            }
            $i = count($this->items_attr[$this->item_count-1]['links']);

            if (isset($attribute['href']))     $this->items_attr[$this->item_count-1]['links'][$i]['href']     = $attribute['href'];
            if (isset($attribute['rel']))      $this->items_attr[$this->item_count-1]['links'][$i]['rel']      = $attribute['rel'];
            if (isset($attribute['type']))     $this->items_attr[$this->item_count-1]['links'][$i]['type']     = $attribute['type'];
            if (isset($attribute['hreflang'])) $this->items_attr[$this->item_count-1]['links'][$i]['hreflang'] = $attribute['hreflang'];
            if (isset($attribute['title']))    $this->items_attr[$this->item_count-1]['links'][$i]['title']    = $attribute['title'];
            if (isset($attribute['length']))   $this->items_attr[$this->item_count-1]['links'][$i]['length']   = $attribute['length'];
            if ($i == 0) $this->items_attr[$this->item_count-1]['link'] = $this->items_attr[$this->item_count-1]['links'][$i];
            break;
        case '/feed/entry/title':
            $this->items[$this->item_count-1]['title'] = $text;
            if (isset($attribute['type'])) $this->items_attr[$this->item_count-1]['title']['type'] = $attribute['type'];
            break;
        case '/feed/entry/category':
            if (!isset($this->items_attr[$this->item_count-1]['category'])) {
                $this->items_attr[$this->item_count-1]['category']   = array();
                $this->items_attr[$this->item_count-1]['categories'] = array();
            }
            $i = count($this->items_attr[$this->item_count-1]['categories']);

            if (isset($attribute['term']))   $this->items_attr[$this->item_count-1]['categories'][$i]['term']   = $attribute['term'];
            if (isset($attribute['scheme'])) $this->items_attr[$this->item_count-1]['categories'][$i]['scheme'] = $attribute['scheme'];
            if (isset($attribute['label']))  $this->items_attr[$this->item_count-1]['categories'][$i]['label']  = $attribute['label'];
            if ($i == 0) $this->items_attr[$this->item_count-1]['category'] = $this->items_attr[$this->item_count-1]['categories'][$i];
            break;
        case '/feed/entry/author':
            if (!isset($this->items[$this->item_count-1]['author'])) {
                $this->items[$this->item_count-1]['author']  = array();
                $this->items[$this->item_count-1]['authors'] = array();
            }
            $index = count($this->items[$this->item_count-1]['authors']);
            break;
        case '/feed/entry/author/name':
            $this->items[$this->item_count-1]['authors'][$index]['name'] = $text;
            if ($index == 0) $this->items[$this->item_count-1]['author']['name'] = $text;
            break;
        case '/feed/entry/author/uri':
            $this->items[$this->item_count-1]['authors'][$index]['uri'] = $text;
            if ($index == 0) $this->items[$this->item_count-1]['author']['uri'] = $text;
            break;
        case '/feed/entry/author/email':
            $this->items[$this->item_count-1]['authors'][$index]['email'] = $text;
            if ($index == 0) $this->items[$this->item_count-1]['author']['email'] = $text;
            break;
        case '/feed/entry/id': $this->items[$this->item_count-1]['id'] = $text; break;
        case '/feed/entry/published':
            $this->items[$this->item_count-1]['published'] = $text;
            $this->items[$this->item_count-1]['date']      = $this->convertDateTime($text);
            break;
        case '/feed/entry/source': $this->items[$this->item_count-1]['source'] = $text; break;
        case '/feed/entry/rights':
            $this->items[$this->item_count-1]['rights']    = $text;
            $this->items[$this->item_count-1]['copyright'] = $text;
            if (isset($attribute['type'])) {
                $this->items_attr[$this->item_count-1]['rights']['type']    = $attribute['type'];
                $this->items_attr[$this->item_count-1]['copyright']['type'] = $attribute['type'];
            }
            break;
        case '/feed/entry/contributor':
            if (!isset($this->items[$this->item_count-1]['contributor'])) {
                $this->items[$this->item_count-1]['contributor']  = array();
                $this->items[$this->item_count-1]['contributors'] = array();
            }
            $index = count($this->items[$this->item_count-1]['contributors']);
            break;
        case '/feed/entry/contributor/name':
            $this->items[$this->item_count-1]['contributors'][$index]['name'] = $text;
            if ($index == 0) $this->items[$this->item_count-1]['contributor']['name'] = $text;
            break;
        case '/feed/entry/contributor/uri':
            $this->items[$this->item_count-1]['contributors'][$index]['uri'] = $text;
            if ($index == 0) $this->items[$this->item_count-1]['contributor']['uri'] = $text;
            break;
        case '/feed/entry/contributor/email':
            $this->items[$this->item_count-1]['contributors'][$index]['email'] = $text;
            if ($index == 0) $this->items[$this->item_count-1]['contributor']['email'] = $text;
            break;
        case '/feed/entry/updated':
            $this->items[$this->item_count-1]['updated'] = $text;
            $this->items[$this->item_count-1]['date']    = $this->convertDateTime($text);
            break;
        case '/feed/entry/summary':
            $this->items[$this->item_count-1]['summary'] = $text;
            if (isset($attribute['type'])) $this->items_attr[$this->item_count-1]['summary']['type'] = $attribute['type'];
            break;
        }
    }
}

?>
