<?php
/**
 * ץȺ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: index.php,v 1.2 2007/05/27 16:24:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class Index
{
    var $version = SYL_VERSION;

    var $c_action; // 󥸥
    var $c_application; // 󥸥
    var $c_controller; // 󥸥
    var $c_template; // 󥸥
    var $c_project; // 󥸥

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function Index()
    {
    }

    /**
     * ɽ
     *
     * @access public
     * @param object ܾ󥪥֥
     * @param object ݡͥȥ᥽åɥ֥
     */
    function execute(&$data, &$context)
    {
        $cmd =& $context->getConsole();

        switch (strtolower($data->get(1))) {
        case 'project':
        case 'pro':
            include_once 'project.php';
            $obj =& new Project();
            $obj->c_action      =& $this->c_action;
            $obj->c_application =& $this->c_application;
            $obj->c_controller  =& $this->c_controller;
            $obj->c_template    =& $this->c_template;
            $obj->c_project     =& $this->c_project;
            $obj->execute($data, &$context);
            break;
        case 'application':
        case 'app':
            include_once 'application.php';
            $obj =& new Application();
            $obj->c_action      =& $this->c_action;
            $obj->c_application =& $this->c_application;
            $obj->c_controller  =& $this->c_controller;
            $obj->c_template    =& $this->c_template;
            $obj->execute($data, &$context);
            break;
        case 'controller':
        case 'con':
            include_once 'controller.php';
            $obj =& new Controller();
            $obj->c_controller =& $this->c_controller;
            break;
        case 'action':
        case 'act':
            include_once 'action.php';
            $obj =& new Action();
            $obj->c_action =& $this->c_action;
            $obj->execute($data, &$context);
            break;
        case 'template':
        case 'tem':
            include_once 'template.php';
            $obj =& new Template();
            $obj->c_template =& $this->c_template;
            break;
        default:
            // С󥳥ޥ
            if ($data->is('h') || $data->is('-help')) {
                $this->displayHelp($data->get(0), $cmd);
            // إץޥ
            } else if ($data->is('v') || $data->is('-version')) {
                $this->displayVersion($data->get(0), $cmd);
            } else {
                $this->displayDefault($data->get(0), $cmd);
            }
        }
    }

    /**
     * إפɽ
     *
     * @access public
     * @param object ܾ󥪥֥
     */
    function displayHelp($file, &$cmd)
    {
        $help = <<<EOF
Usage:
  {$file} project [or pro] -d <dir> -w <name> [-c <file>]
  {$file} application [or app] -d <dir> -w <name> [-c <file>]
  {$file} controller [or con] -d <dir> -w <name> -c <file>
  {$file} action [or act] -d <dir> -w <name> -a <name>
  {$file} template [or tem] -d <dir> -w <name> -t <name>
  {$file} [option]

Options:
  -d <dir>  project directory
  -w <name> application name
  -c <file> front controller file
  -a <name> action file (path from action directory)
  -t <name> template file (path from template directory)
  -h        show this help, then exit
  -v        output version information, then exit
EOF;
        $cmd->stdout($help);
    }

    /**
     * Сɽ
     *
     * @access public
     * @param object ܾ󥪥֥
     */
    function displayVersion($file, &$cmd)
    {
        $php_version = PHP_VERSION;
        $php_sapi    = PHP_SAPI;
        $php_os      = PHP_OS;
       // $php_version = PHP_SAPI;
        $version = <<<EOF
{$file} - SyL {$this->version} (on PHP {$php_version} {$php_sapi} - {$php_os})
Copyright (c) 2006-2007 k.watanabe
EOF;
        $cmd->stdout($version);
    }

    /**
     * ǥեɽ
     *
     * @access public
     * @param object ܾ󥪥֥
     */
    function displayDefault($file, &$cmd)
    {
        $default = <<<EOF
{$file}: too few arguments
Try `php {$file} --help' for more information.
EOF;
        $cmd->stdout($default);
    }
}

?>
