<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Data.php,v 1.3 2007/05/08 15:55:06 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ѥץѥƥ饹
 */
require_once SYL_INCLUDE_DIR . '/lib/Util/SyL_UtilProperty.php';

/**
 * ե졼ǡݻ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Data.php,v 1.3 2007/05/08 15:55:06 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Data extends SyL_UtilProperty
{
    /**
     * ϥǡ
     *
     * @access protected
     * @var array
     */
    var $input_parameters = array();

    /**
     * ǡݻ饹Υ󥹥󥹼
     *
     * @access public
     * @return object ǡݻ֥
     */
    function &getInstance()
    {
        static $singleton;
        if (!is_object($singleton)) {
            $classname = 'SyL_Data' . ucfirst(SYL_ENV_TYPE);
            include_once SYL_INCLUDE_DIR . "/framework/Data/{$classname}.php";
            // ҥ饹Υ󥹥
            $singleton = new $classname();
        }
        return $singleton;
    }

    /**
     * ץѥƥ򥻥å
     * 
     * @access public
     * @param string ץѥƥ̾
     * @param string ץѥƥ
     */
    function set($name, $value)
    {
        $this->checkName($name);
        parent::set($name, $value);
    }

    /**
     * ץѥƥ򥻥åȡʻȡ
     * 
     * @access public
     * @param string ץѥƥ̾
     * @param string ץѥƥ
     */
    function setRef($name, &$value)
    {
        $this->checkName($name);
        parent::setRef($name, $value);
    }

    /**
     * ʣץѥƥ򥻥å
     * 
     * @access public
     * @param array ץѥƥ
     */
    function sets($values)
    {
        foreach (array_keys($values) as $name) {
            $this->checkName($name);
            $this->set($name, $values[$name]);
        }
    }

    /**
     * ʣץѥƥ򥻥åȡʻȡ
     * 
     * @access public
     * @param array ץѥƥ
     */
    function setsRef(&$values)
    {
        foreach (array_keys($values) as $name) {
            $this->checkName($name);
            $this->setRef($name, $values[$name]);
        }
    }

    /**
     * ץѥƥ
     * 
     * @access public
     * @param string ץѥƥ̾
     * @return string ץѥƥ
     */
    function get($name)
    {
        $value = parent::get($name);
        if (($value === null) && isset($this->input_parameters[$name])) {
            $value = $this->input_parameters[$name];
        }
        return $value;
    }

    /**
     * ץѥƥʻȡ
     * 
     * @access public
     * @param string ץѥƥ̾
     * @return string ץѥƥ
     */
    function &getRef($name)
    {
        $value =& parent::getRef($name);
        if (($value === null) && isset($this->input_parameters[$name])) {
            $value =& $this->input_parameters[$name];
        }
        return $value;
    }

    /**
     * ץѥƥ
     * 
     * @access public
     * @return array ץѥƥ
     */
    function gets()
    {
        return parent::gets() + $this->input_parameters;
    }

    /**
     * ץѥƥʻȡ
     * 
     * @access public
     * @return array ץѥƥ
     */
    function &getsRef()
    {
        $values =& parent::getsRef();
        foreach (array_keys($this->input_parameters) as $name) {
            if (!isset($values[$name])) {
                $values[$name] =& $this->input_parameters[$name];
            }
        }
        return $values;
    }

    /**
     * ϥѥ᡼򥻥å
     * 
     * @access public
     * @param array ϥѥ᡼
     */
    function setInputParameters($values)
    {
        $this->input_parameters = $values;
    }

    /**
     * ѥ᡼ϡʻȡ
     * 
     * @access public
     * @return array ϥѥ᡼
     */
    function &getOutputParameters()
    {
        return parent::getsRef();
    }

    /**
     * ϥѥ᡼ϥѥ᡼ƩŪϤ
     * 
     * @access public
     */
    function throwParameters()
    {
        $this->sets($this->input_parameters);
    }

    /**
     * ѥ᡼˻ؿŬѤ
     * 
     * @access private
     * @param array ѥ᡼
     * @param string ؿ̾
     */
    function apply($func)
    {
        $func_parameters = func_get_args();
        $func = array_shift($func_parameters);
        parent::apply($func, $func_parameters);
        parent::applyRecursive($func, $this->input_parameters, $func_parameters);
    }

    /**
     * ץ饤١ȥץѥƥ̾å
     * 
     * @access public
     * @param string ץѥƥ̾
     */
    function checkName($name)
    {
        if (substr($name, 0, 1) == '_') {
            trigger_error("[SyL error] Data property name invalid first char ({$name})", E_USER_ERROR);
        }
    }
}

?>
