<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDaoTable.php,v 1.1 2007/06/24 10:44:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ơ֥륹饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDaoTable.php,v 1.1 2007/06/24 10:44:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBDaoTable
{
    /**
     * ơ֥̾
     * 
     * @access protected
     * @var string
     */
    var $table = '';
    /**
     * ơ֥̾
     * 
     * @access protected
     * @var string
     */
    var $alias = '';
    /**
     * ץ饤ޥꥭ
     * 
     * @access protected
     * @var array
     */
    var $primary_keys = array();
    /**
     * 
     *
     * @access protected
     * @var array
     */
    var $columns = array();
    /**
     * оݥ
     * 
     * @access private
     * @var array
     */
    var $data_columns = array();
    /**
     * 索֥
     * 
     * @access protected
     * @var object
     */
    var $conditions = null;
    /**
     * ȥ
     * 
     * @access protected
     * @var array
     */
    var $order_bys = array();

    /**
     * ͤɲ
     *
     * @access public
     * @param string ̾
     * @param mixed 
     */
    function addColumn($name, $value=null)
    {
        if (isset($this->columns[$name])) {
            $this->data_columns[$name] = $value;
        } else {
            trigger_error("[SyL error] Column name not found in " . get_class($this) . " class ({$name})", E_USER_ERROR);
        }
    }

    /**
     * ơ֥̾
     *
     * @access public
     * @return string ơ֥̾
     */
    function getName()
    {
        return $this->table;
    }

    /**
     * ơ֥̾򥻥å
     *
     * @access public
     * @param string ơ֥̾
     */
    function setAliasName($alias)
    {
        $this->alias = $alias;
    }

    /**
     * ơ֥̾
     *
     * @access public
     * @return string ơ֥̾
     */
    function getAliasName()
    {
        return $this->alias;
    }

    /**
     * 
     *
     * @access public
     * @return array 
     */
    function getColumns()
    {
        return $this->columns;
    }

    /**
     * 祭
     *
     * @access public
     * @return array 祭
     */
    function getPrimaryKeys()
    {
        return $this->primary_keys;
    }

    /**
     * 索֥Ȥ򥻥å
     *
     * @access public
     * @param object 索֥
     */
    function setConditions($conditions)
    {
        $this->conditions = $conditions;
    }

    /**
     * 索֥Ȥ
     *
     * @access public
     * @return object 索֥
     */
    function getConditions()
    {
        if ($this->conditions !== null) {
            $this->conditions->setAlias($this->getAliasName());
        }
        return $this->conditions;
    }

    /**
     * ȥɲ
     *
     * @access public
     * @param string ȥ
     */
    function addSort($name)
    {
        if (isset($this->columns[$name])) {
            $this->order_bys[] = $name;
        } else {
            trigger_error("[SyL error] Sort column name not found in " . get_class($this) . " class ({$name})", E_USER_ERROR);
        }
    }

    /**
     * ȥ
     *
     * @access public
     * @param bool 祭ȥե饰
     * @return array ȥ
     */
    function getSorts($primary_sort=true)
    {
        $order_bys = $this->order_bys;
        if ($primary_sort) {
            foreach ($this->primary_keys as $primary_key) {
                if (!in_array($primary_key, $order_bys)) {
                    $order_bys[] = $primary_key;
                }
            }
        }

        if ($this->alias) {
            for ($i=0; $i<count($order_bys); $i++) {
                $order_bys[$i] = $this->alias . '.' . $order_bys[$i];
            }
        }
        return $order_bys;
    }

    /**
     * SELECTѥơ֥̾
     *
     * @access public
     * @return array SELECT
     */
    function getSelectName()
    {
        if ($this->alias) {
            return $this->getName() . ' ' . $this->alias;
        } else {
            return $this->getName();
        }
    }

    /**
     * SELECTܤ
     *
     * @access public
     * @return array SELECT
     */
    function getSelectColumns()
    {
        $columns = array();
        if (count($this->data_columns) > 0) {
            foreach ($this->data_columns as $name => $value) {
                if ($value) {
                    $name .= " AS {$value}";
                }
                $columns[] = $name;
            }
        } else {
            $columns = array_keys($this->columns);
        }

        if ($this->alias) {
            for ($i=0; $i<count($columns); $i++) {
                $columns[$i] = $this->alias . '.' . $columns[$i];
            }
        }
        return $columns;
    }

    /**
     * SELECT̾
     *
     * @access public
     * @return array SELECT̾
     */
    function getSelectColumnNames()
    {
        $columns = array();
        if (count($this->data_columns) > 0) {
            foreach ($this->data_columns as $name => $value) {
                if (isset($this->columns[$name]) && $this->columns[$name]) {
                    $columns[$name] = $this->columns[$name];
                } else {
                    $columns[$name] = $name;
                }
            }
        } else {
            foreach ($this->columns as $name => $alias_name) {
                if ($alias_name) {
                    $columns[$name] = $alias_name;
                } else {
                    $columns[$name] = $name;
                }
            }
        }
        return $columns;
    }

    /**
     * DMLѹܤ
     *
     * @access public
     * @param bool ơ֥̾ɲåե饰
     * @return array DMLѹ
     */
    function getDataColumns($is_alias=false)
    {
        if ($is_alias && $this->alias) {
            $columns = array();
            foreach ($this->data_columns as $name => $value) {
                $columns[$this->alias . '.' . $name] = $value;
            }
            return $columns;
        } else {
            return $this->data_columns;
        }

    }
}

?>
