<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDao.php,v 1.1 2007/06/24 10:44:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * SQL饹
 */
require_once 'SyL_DBSqlTableConditions.php';

/**
 * DBѥǡ饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDao.php,v 1.1 2007/06/24 10:44:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBDao
{
    /**
     * DB֥
     *
     * @access protected
     * @var object
     */
    var $conn = null;
    /**
     * ޥ֥Ȥ
     *
     * @access protected
     * @var array
     */
    var $tables = array();
    /**
     * SELECT
     *
     * @access private
     * @var array
     */
    var $select_columns = array();
    /**
     * Ϣ³DML˥顼ȯ硢
     * ߤե饰
     *
     * @access protected
     * @var bool
     */
    var $error_stop = true;
    /**
     * 顼å
     *
     * @access protected
     * @var array
     */
    var $error_messages = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param object DB֥
     */
    function SyL_DBDao(&$conn)
    {
        $this->conn =& $conn;
    }

    /**
     * 索֥Ⱥ
     *
     * @access public
     * @return object 索֥
     */
    function createCondition()
    {
        return new SyL_DBSqlTableConditions();
    }

    /**
     * SELECTܤ
     *
     * @access public
     * @return array SELECT
     */
    function getSelectColumns()
    {
        return $this->select_columns;
    }

    /**
     * DBǡ
     *
     * @access public
     * @param mixed ơ֥륪֥ 
     * @param string ơ֥Υꥢ̾
     * @return bool true: OK, false: 顼
     */
    function select($table, $alias='')
    {
        // ѤѴ
        $table = $this->arrangeTables($table, $alias);

        $selects   = array();
        $froms     = array();
        $wheres    = array();
        $order_bys = array();
        $this->select_columns = array();
        foreach(array_keys($table) as $name) {
            $selects    = array_merge($selects, $table[$name]->getSelectColumns());
            $froms      = array_merge($froms, (array)$table[$name]->getSelectName());
            $conditions = $table[$name]->getConditions();
            $wheres[]   = ($conditions) ? $conditions->getWhere($this->conn) : '';
            $order_bys  = array_merge($order_bys, $table[$name]->getSorts());

            $this->select_columns = array_merge($this->select_columns, $table[$name]->getSelectColumnNames());
        }

        $where    = implode(' AND ', $wheres);
        $order_by = implode(', ', $order_bys);

        $sql  = "";
        $sql .= "SELECT ";
        $sql .=   implode(', ', $selects) . " ";
        $sql .= "FROM ";
        $sql .=   implode(', ', $froms) . " ";
        if ($where) {
        $sql .= "WHERE ";
        $sql .=   $where . " ";
        }
        if ($order_by) {
        $sql .= "ORDER BY ";
        $sql .=   $order_by . " ";
        }

        return $this->conn->query($sql);
    }


    /**
     * DBϿ
     *
     * @access public
     * @param mixed ơ֥륪֥
     * @param string ơ֥Υꥢ̾
     * @return bool true: OK, false: 顼
     */
    function insert($table, $alias='')
    {
        // ѤѴ
        $table = $this->arrangeTables($table, $alias);
        // INSERT¹
        return $this->exec($table, 'insert');
    }

    /**
     * DB򹹿
     *
     * @access public
     * @param mixed ơ֥륪֥
     * @param string ơ֥Υꥢ̾
     * @return bool true: OK, false: 顼
     */
    function update($table, $alias='')
    {
        // ѤѴ
        $table = $this->arrangeTables($table, $alias);
        // UPDATE¹
        return $this->exec($table, 'update');
    }

    /**
     * DB
     *
     * @access public
     * @param mixed ơ֥륪֥
     * @param string ơ֥Υꥢ̾
     * @return bool true: OK, false: 顼
     */
    function delete($table, $alias='')
    {
        // ѤѴ
        $table = $this->arrangeTables($table, $alias);
        // DELETE¹
        return $this->exec($table, 'delete');
    }

    /**
     * ơ֥륪֥Ȥѥ᡼ѤѴ
     *
     * @access private
     * @param mixed ơ֥륪֥
     * @param string ơ֥Υꥢ̾
     */
    function arrangeTables($table, $alias='')
    {
        $result = array();
        // ơ֥륪֥Ȥξ
        if (is_object($table)) {
            if ($alias) {
                $table->setAliasName($alias);
            } else {
                $alias = $table->getName();
            }
            $result[$alias] = $table;
        } else if (is_array($table)) {
            if (isset($table[0])) {
                if (is_array($table[0])) {
                    foreach (array_keys($table) as $key) {
                        $result += $this->arrangeTables($table[$key]);
                    }
                } else {
                    if (isset($table[1])) {
                        $result += $this->arrangeTables($table[0], $table[1]);
                    } else {
                        $result += $this->arrangeTables($table[0]);
                    }
                }
            }
        }
        return $result;
    }

    /**
     * DBϿѤ˥
     *
     * @access private
     * @param array ơ֥륪֥
     * @param string insert or update or delete
     * @return bool true: OKfalse: 顼
     */
    function exec($table, $action)
    {
        $result = true;
        foreach (array_keys($table) as $name) {
            $conditions = $table[$name]->getConditions();
            $where      = ($conditions) ? $conditions->getWhere($this->conn) : '';
            if (!$this->conn->execPerform($table[$name]->getName(), $table[$name]->getDataColumns(), $action, $where)) {
                $result = false;
                $this->error_messages[] = $this->conn->errorInfo();
                if ($this->error_stop) {
                    break;
                }
            }
        }
        return $result;
    }

    /**
     * 顼Ƚꤹ
     *
     * @access public
     * @return bool true: 顼, false: 顼ʤ
     */
    function isError()
    {
        return (count($this->error_messages) > 0);
    }

    /**
     * 顼åƼ
     *
     * @access public
     * @return array 顼å
     */
    function getErrors()
    {
        return $this->error_messages;
    }

}

?>
