<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidatorDate.php,v 1.2 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ոڥ饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidatorDate.php,v 1.2 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ValidationValidatorDate extends SyL_ValidationValidator
{
    /**
     * ѥ᡼
     *
     * @access protected
     * @var array
     */
    var $parameters = array(
      'past'      => null,
      'future'    => null,
      'min'       => null, // strtotimeեޥå
      'min_error_message' => null,
      'max'       => null, // strtotimeեޥå
      'max_error_message' => null
    );

    /**
     * ոڽ¹Ԥ
     *
     * @access public
     * @param string о
     * @return bool true: 顼̵, false: 顼
     */
    function validate($value)
    {
        $yyyy = $mm = $dd = '';
        $hh   = $mi = $ss = '';
        if (preg_match('/^([0-9]{4})[\-\/]?([0-1][0-9])[\-\/]?([0-9]{2})\s?([0-1][0-9]|2[0-3]):?([0-5][0-9]):?([0-5][0-9])$/', $value, $matches)) {
          $yyyy = $matches[1];
          $mm   = $matches[2];
          $dd   = $matches[3];
          $hh   = $matches[4];
          $mi   = $matches[5];
          $ss   = $matches[6];
        } else if (preg_match('/^([0-9]{4})[\-\/]?([0-1][0-9])[\-\/]?([0-9]{2})$/', $value, $matches)) {
          $yyyy = $matches[1];
          $mm   = $matches[2];
          $dd   = $matches[3];
        } else {
          return false;
        }

        if (!checkdate($mm, $dd, $yyyy)) {
            return false;
        }

        $now = getdate();
        $ymd = mktime(0, 0, 0, $mm, $dd, $yyyy);

        if ($this->parameters['past']) {
            if (mktime(0, 0, 0, $now['mon'], $now['mday'], $now['year']) < $ymd) {
                return false;
            }
        }

        if ($this->parameters['future']) {
            if (mktime(0, 0, 0, $now['mon'], $now['mday'], $now['year']) > $ymd) {
                return false;
            }
        }

        if ($this->parameters['min']) {
            if (strtotime($this->parameters['min']) > $ymd) {
                if ($this->parameters['min_error_message']) {
                    $this->error_message = $this->parameters['min_error_message'];
                }
                return false;
            }
        }

        if ($this->parameters['max']) {
            if (strtotime($this->parameters['max']) < $ymd) {
                if ($this->parameters['max_error_message']) {
                    $this->error_message = $this->parameters['max_error_message'];
                }
                return false;
            }
        }

        return true;
    }

    /**
     * ոڽJavaScript
     *
     * @access public
     * @return string JavaScriptå
     */
    function getJsCode()
    {
        $date   = date('Y-m-d');
        $past   = ($this->parameters['past'])   ? 'true' : 'false';
        $future = ($this->parameters['future']) ? 'true' : 'false';
        $min    = ($this->parameters['min']) ? date('Y-m-d', strtotime($this->parameters['min'])) : '';
        $max    = ($this->parameters['max']) ? date('Y-m-d', strtotime($this->parameters['max'])) : '';
        $min_error_message = $this->parameters['min_error_message'];
        $max_error_message = $this->parameters['max_error_message'];

        $options = array();
        $options[] = "'date': '{$date}'";
        $options[] = "'past': {$past}";
        $options[] = "'future': {$future}";
        $options[] = "'min': '{$min}'";
        $options[] = "'max': '{$max}'";
        $options[] = "'min_error_message': '{$min_error_message}'";
        $options[] = "'max_error_message': '{$max_error_message}'";
        $options[] = "'min_valids': '{$this->min_valids}'";
        $options[] = "'max_valids': '{$this->max_valids}'";

        $js  = '';
        $js .= 'if (!error_message) {' . "\n";
        $js .= '  var error_message_tmp = validation.isDate(element_name, "' . $this->getErrorMessage() . '", {' . implode(',', $options) . '});' . "\n";
        $js .= '  if (error_message_tmp) {' . "\n";
        $js .= '    error_message = error_message_tmp;' . "\n";
        $js .= '  }' . "\n";
        $js .= '}' . "\n";
        return $js;
    }
}

?>
