<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorWeb.php,v 1.20 2007/07/08 04:22:38 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEB̥顼ɽ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorWeb.php,v 1.20 2007/07/08 04:22:38 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ErrorWeb extends SyL_Error
{
    var $display_source_line = 9; // ˤ

    /**
     * Ķ̥顼
     * 
     * @access public
     * @param array 顼å
     * @param array 顼ȥ졼
     */
    function displayError($error_messages, $error_trace)
    {
        // display_errorsoffξϥ顼̤ɽʤ
        if (!ini_get('display_errors')) {
            return;
        }

        // 顼å
        $error_message = implode('<br>', $error_messages);

        // 顼
        $error_lines = array();
        if (SYL_ERROR_TRACE) {
            foreach ($error_trace as $error) {
                $error_line = $error['line'];
                $error_file = $error['file'];
                if (is_numeric($error_line) && file_exists($error_file)) {
                    $error_half_line = floor($this->display_source_line / 2);
                    $start_line = 1;
                    $crit_line  = 1;
                    if (($error_line - $error_half_line) > 1) {
                        $start_line = $error_line - $error_half_line;
                    }
                    $i = 1;
                    $tmp_lines = array();
                    foreach (file($error_file) as $line => $source) {
                        if (($line + 1) >= $start_line) {
                            if (($line + 1) == $error_line) {
                                $tmp_lines[] = '<span style="color: #FF0000">Line ' . ($line + 1) . ': ' . htmlspecialchars($source) . '</span>';
                            } else {
                                $tmp_lines[] = 'Line ' . ($line + 1) . ': ' . htmlspecialchars($source);
                            }
                            if ($i >= $this->display_source_line) {
                                break;
                            }
                            $i++;
                        }
                    }
                    $error_lines[$error['no']] = implode('', $tmp_lines);
                } else {
                    $error_lines[$error['no']] = '';
                }
            }
        }

        // 顼ɽȽ
        $error_View_type = '';
        $view_type = explode(':', SYL_ERROR_FORWARD_TYPE);
        switch (strtolower($view_type[0])) {
        case 'redirect':
            $error_View_type = 'Redirect';
            $template_file   = SYL_ERROR_FORWARD_FILE;
            break;
        case 'view':
        case 'layout':
            $error_View_type = 'Template';
            $template_file   = SYL_ERROR_FORWARD_FILE;
            break;
        default:
            $error_View_type = 'Default';
            $template_file   = SYL_INCLUDE_DIR . '/framework/Error/default_error_web.php';
            break;
        }

        // 顼ɽ
        $func_name = "displayError{$error_View_type}";
        // 顼åɽ
        $this->{$func_name}($template_file, $error_message, $error_lines, $error_trace, $view_type);
    }

    /**
     * ǥեȥƥץ졼ȥ顼
     *
     * @access private
     * @param string ƥץ졼ȥե
     * @param string 顼å
     * @param string 顼ȥ졼
     * @param string ӥ塼
     */
    function displayErrorDefault($template_file, $_error_message, $_error_lines, $_error_trace, $view_type)
    {
        // ɽƤ
        ob_start();
        include_once $template_file;
        $contents = ob_get_clean();

        $content_type = 'text/html; charset=' . SYL_ENCODE_INTERNAL;
        SyL_Response::setHeader('Content-Type', $content_type);
        $response =& SyL_Response::singleton();
        $response->display($contents);
    }

    /**
     * ƥץ졼ȥ顼
     *
     * @access private
     * @param string ƥץ졼ȥե
     * @param string 顼å
     * @param string 顼ȥ졼
     * @param string ӥ塼
     */
    function displayErrorTemplate($template_file, $_error_message, $_error_lines, $_error_trace, $view_type)
    {
        // ǡ饹
        include_once SYL_INCLUDE_DIR . '/framework/SyL_Context.php';
        $context =& new SyL_Context($this->controller);
        $context->setViewType($view_type[1]);
        $context->setTemplateFile($template_file);
        $context->setParameter('_error_message', $_error_message);
        $context->setParameter('_error_lines',   $_error_lines);
        $context->setParameter('_error_trace',   $_error_trace);

        // ӥ塼饹
        include_once SYL_INCLUDE_DIR . '/framework/SyL_View.php';
        $view =& SyL_View::getObject($context);
        $view->render();

        $response =& SyL_Response::singleton();
        $response->display($view);
    }

    /**
     * 顼ڡ˥쥯
     *
     * @access private
     * @param string ƥץ졼ȥե
     * @param string 顼å
     * @param string 顼ȥ졼
     * @param string ӥ塼
     */
    function displayErrorRedirect($template_file, $_error_message, $_error_lines, $_error_trace, $view_type)
    {
        SyL_Response::redirect($template_file);
    }

}

?>
