<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDaoTable.php,v 1.2 2007/07/08 04:22:38 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ơ֥륹饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDaoTable.php,v 1.2 2007/07/08 04:22:38 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBDaoTable
{
    /**
     * ơ֥̾
     * 
     * @access protected
     * @var string
     */
    var $table = '';
    /**
     * ơ֥̾
     * 
     * @access protected
     * @var string
     */
    var $alias = '';
    /**
     * ץ饤ޥꥭ
     * 
     * @access protected
     * @var array
     */
    var $primary = array();
    /**
     * 
     *
     * @access protected
     * @var array
     */
    var $columns = array();
    /**
     * оݥ
     * 
     * @access private
     * @var array
     */
    var $data_columns = array();
    /**
     * 索֥
     * 
     * @access protected
     * @var object
     */
    var $conditions = null;
    /**
     * ȥ
     * 
     * @access protected
     * @var array
     */
    var $order_bys = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_DBDaoTable()
    {
        // ̾ʸѴ
        $this->primary = array_map('strtoupper', $this->primary);
        $this->columns = array_change_key_case($this->columns, CASE_UPPER);
    }

    /**
     * ͤɲ
     *
     * @access public
     * @param string ̾
     * @param mixed 
     */
    function addColumn($name, $value=null)
    {
        // ʸ
        $name = strtoupper($name);
        if (isset($this->columns[$name])) {
            $this->data_columns[$name] = $value;
        } else {
            trigger_error("[SyL error] Column name not found in " . get_class($this) . " class ({$name})", E_USER_ERROR);
        }
    }

    /**
     * ơ֥̾
     *
     * @access public
     * @return string ơ֥̾
     */
    function getName()
    {
        return $this->table;
    }

    /**
     * ơ֥̾򥻥å
     *
     * @access public
     * @param string ơ֥̾
     */
    function setAliasName($alias)
    {
        $this->alias = $alias;
    }

    /**
     * ơ֥̾
     *
     * @access public
     * @return string ơ֥̾
     */
    function getAliasName()
    {
        return ($this->alias) ? $this->alias : $this->table;
    }

    /**
     * SELECTѥơ֥̾
     *
     * @access public
     * @return array SELECT
     */
    function getSelectName()
    {
        if ($this->alias) {
            return $this->getName() . ' ' . $this->alias;
        } else {
            return $this->getName();
        }
    }

    /**
     * 
     *
     * @access public
     * @return array 
     */
    function getColumns()
    {
        return $this->columns;
    }

    /**
     * 祭
     *
     * @access public
     * @return array 祭
     */
    function getPrimary()
    {
        $alias = $this->getAliasName();
        $primary = array();
        foreach ($this->primary as $tmp) {
            $primary[] = "{$alias}.{$tmp}";
        }
        return $primary;
    }

    /**
     * 索֥Ȥ򥻥å
     *
     * @access public
     * @param object 索֥
     */
    function setConditions($conditions)
    {
        $this->conditions = $conditions;
    }

    /**
     * 索֥Ȥ
     *
     * @access public
     * @return object 索֥
     */
    function getConditions()
    {
        if ($this->conditions !== null) {
            $this->conditions->setAlias($this->getAliasName());
        }
        return $this->conditions;
    }

    /**
     * ȥɲ
     *
     * @access public
     * @param string ȥ
     * @param bool Ƚ
     */
    function addSort($name, $asc=true)
    {
        // ʸ
        $name = strtoupper(trim($name));
        if (isset($this->columns[$name])) {
            $this->order_bys[] = array($name, $asc);
        } else {
            trigger_error("[SyL error] Sort column name not found in " . get_class($this) . " class ({$name})", E_USER_ERROR);
        }
    }

    /**
     * ȥ󥯤饽ȥɲ
     *
     * @access public
     * @param string ȥ
     */
    function addSortLink($linkname)
    {
        $sorts = array_map('trim', explode('.', $linkname, 3));
        if (count($sorts) == 3) {
            if ($this->getAliasName() == $sorts[0]) {
                $this->addSort($sorts[1], ($sorts[2] == 'ASC'));
            }
        }
    }

    /**
     * ȥ
     *
     * @access public
     * @param bool 祭ȥե饰
     * @return array ȥ
     */
    function getSorts($primary_sort=true)
    {
        $order_bys = $this->order_bys;
        if ($primary_sort) {
            foreach ($this->primary as $primary) {
                $exist = false;
                foreach ($order_bys as $order_by) {
                    if ($primary == $order_by[0]) {
                        $exist = true;
                        break;
                    }
                }
                if (!$exist) {
                    $order_bys[] = array($primary, true);
                }
            }
        }

        $result = array();
        for ($i=0; $i<count($order_bys); $i++) {
            $sort = ($order_bys[$i][1]) ? 'ASC' : 'DESC';
            $result[$i] = $this->getAliasName() . '.' . $order_bys[$i][0] . ' ' . $sort;
        }
        return $result;
    }

    /**
     * SELECTܤ
     *
     * @access public
     * @return array SELECT
     */
    function getSelectColumns()
    {
        $columns = array();
        if (count($this->data_columns) > 0) {
            foreach ($this->data_columns as $name => $value) {
                if ($value) {
                    $name .= " AS {$value}";
                }
                $columns[] = $name;
            }
        } else {
            $columns = array_keys($this->columns);
        }

        for ($i=0; $i<count($columns); $i++) {
            $columns[$i] = $this->getAliasName() . '.' . $columns[$i];
        }
        return $columns;
    }

    /**
     * SELECT̾
     *
     * @access public
     * @return array SELECT̾
     */
    function getSelectHeaders()
    {
        $alias = $this->getAliasName() . '.';
        $columns     = array();
        $tmp_columns = array();
        if (count($this->data_columns) > 0) {
            foreach (array_keys($this->data_columns) as $name) {
                $tmp_columns[$name] = $this->columns[$name];
            }
        } else {
            $tmp_columns =& $this->columns;
        }
        foreach ($tmp_columns as $name => $name1) {
            $columns[$alias.$name]['name']     = ($name1) ? $name1 : $name;
            $columns[$alias.$name]['primary']  = in_array($name, $this->primary);
            $exist = false;
            foreach ($this->getSorts() as $order_by) {
                list($sort, $order) = explode(' ', $order_by, 2);
                if (($alias.$name) == $sort) {
                    $columns[$alias.$name]['order'] = ($order == 'ASC') ? 'DESC' : 'ASC'; // 󥯤ʤΤǥȤ
                    $exist = true;
                    break;
                }
            }
            if (!$exist) {
                $columns[$alias.$name]['order'] = 'ASC';
            }
            $columns[$alias.$name]['sortlink'] = $alias . $name . '.' . $columns[$alias.$name]['order'];
        }
        return $columns;
    }

    /**
     * DMLѹܤ
     *
     * @access public
     * @param bool ơ֥̾ɲåե饰
     * @return array DMLѹ
     */
    function getDataColumns($is_alias=false)
    {
        if ($is_alias && $this->alias) {
            $columns = array();
            foreach ($this->data_columns as $name => $value) {
                $columns[$this->getAliasName() . '.' . $name] = $value;
            }
            return $columns;
        } else {
            return $this->data_columns;
        }
    }
}

?>
