<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRpcClientResult.php,v 1.3 2007/04/30 13:15:57 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * HTTPNGXgʃNX
 */
require_once dirname(__FILE__) . '/../../Http/SyL_HttpClientResult.php';
/**
 * XML RPCNGXgʃp[T[NX
 */
require_once 'SyL_XmlRpcClientReader.php';

/**
 * XML RPCNGXgʃNX
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRpcClientResult.php,v 1.3 2007/04/30 13:15:57 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlRpcClientResult extends SyL_HttpClientResult
{
    /**
     * ̕R[h
     *
     * @access protected
     * @var string
     */
    var $original_encode = 'UTF-8';
    /**
     * XMLRPC [_[IuWFNg
     *
     * @access private
     * @var object
     */
    var $reader = null;

    /**
     * RXgN^
     * 
     * @access public
     * @param string NGXg
     * @param string NCAgGR[h
     */
    function SyL_XmlRpcClientResult($data, $client_encode='')
    {
        parent::SyL_HttpClientResult($data, $client_encode);

        // 擪100oCgڂ܂łɃGR[fBO̒`擾
        if (preg_match ('/<\?xml(.*)encoding=\"([^\"]+)\"(.*)\?>/i', substr(ltrim($this->body), 0, 100), $matches)) {
            $this->original_encode = $matches[2];
        }

        $this->reader =& new SyL_XmlRpcClientReader();
        if ($this->original_encode) {
            $this->reader->setXmlEncode($this->original_encode);
        }
        if ($this->client_encode) {
            $this->reader->setClientEncode($this->client_encode);
        }
        $this->reader->setData($this->body);
        $this->reader->parseXml();
    }

    /**
     * XML RPC̖߂l擾
     * 
     * @access public
     * @return mixed XML RPC̖߂l
     */
    function getResult()
    {
        return $this->reader->getValue();
    }

    /**
     * XML RPC̃G[
     * 
     * @access public
     * @return bool true: G[Afalse: G[Ȃ
     */
    function isError()
    {
        return $this->reader->isError();
    }

    /**
     * G[R[h擾
     *
     * @access public
     * @return string G[R[h
     */
    function getErrorCode()
    {
        return $this->reader->getErrorCode();
    }

    /**
     * G[bZ[W擾
     *
     * @access public
     * @return string G[bZ[W
     */
    function getErrorMessage()
    {
        return $this->reader->getErrorMessage();
    }
}

?>
