<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Project.php,v 1.1 2007/06/24 10:44:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ץȺ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Project.php,v 1.1 2007/06/24 10:44:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class Project
{
    var $c_action; // 󥸥
    var $c_application; // 󥸥
    var $c_controller; // 󥸥
    var $c_template; // 󥸥
    var $c_project; // 󥸥

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function Project()
    {
    }

    /**
     * ץȺ
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȥ֥
     */
    function execute(&$data, &$context)
    {
        $project_dir     = $data->get('d');
        $app_name        = $data->get('w');
        $controller_file = $data->get('c');
        //$action_files    = $data->get('a');
        //$template_files  = $data->get('t');

        $cmd =& $context->getConsole();

        // -------------------------------------------------
        // ץȥǥ쥯ȥå
        // -------------------------------------------------
        $cnt = count($project_dir);
        if ($cnt == 0) {
            trigger_error("[SyL error] Project directory (-d) not found", E_USER_ERROR);
            exit;
        } else if ($cnt > 1) {
            trigger_error("[SyL error] Project directory (-d) only 1", E_USER_ERROR);
            exit;
        }

        $project_dir = preg_match('/(\\\\|\/)$/', $project_dir[0]) ? $project_dir[0] : $project_dir[0] . '/';

        if (file_exists($project_dir)) {
            if (!is_writable($project_dir)) {
                trigger_error("[SyL error] Project directory permission denied ({$project_dir})", E_USER_ERROR);
                exit;
            }
            if ($cmd->getInput('', "create project ({$project_dir}) [Y/n]:") != 'Y') {
                exit;
            }
        } else {
            if ($cmd->getInput('', "create directory ({$project_dir}) [Y/n]:") != 'Y') {
                exit;
            }
        }

        // -------------------------------------------------
        // ץꥱ̾å
        // -------------------------------------------------
        $cnt = count($app_name);
        if ($cnt == 0) {
            $app_name = '';
        } else if ($cnt > 1) {
            trigger_error("[SyL error] Application name (-w) only 1", E_USER_ERROR);
            exit;
        } else if (!preg_match('/^[\w\-]+$/', $app_name[0])) {
            trigger_error("[SyL error] Application name format invalid. ([a-z][A-Z][0-9]-_ only)", E_USER_ERROR);
            exit;
        } else {
            $app_name = $app_name[0];
        }

        // -------------------------------------------------
        // ȥեå
        // -------------------------------------------------
        $cnt = count($controller_file);
        if ($cnt == 0) {
            $controller_file = '';
        } else if ($cnt > 1) {
            trigger_error("[SyL error] Controller file (-c) only 1", E_USER_ERROR);
            exit;
        } else {
            $controller_file = $controller_file[0];
        }

        if ($controller_file) {
            if ($app_name == '') {
                trigger_error("[SyL error] Application name not found for create controller", E_USER_ERROR);
                exit;
            } else if (file_exists($controller_file)) {
                if ($cmd->getInput('Already controller file exists', "overwrite controller file ({$controller_file}) [Y/n]:") != 'Y') {
                    exit;
                }
                if (!is_writable($controller_file)) {
                    trigger_error("[SyL error] Create controller file permission denied ({$controller_file})", E_USER_ERROR);
                    exit;
                }
            } else {
                if (!is_writable(dirname($controller_file))) {
                    trigger_error("[SyL error] Create controller file permission denied ({$controller_file})", E_USER_ERROR);
                    exit;
                }
            }
        }

        // -------------------------------------------------
        // եå
        // -------------------------------------------------
        $action_files = array('index');

        // -------------------------------------------------
        // ƥץ졼ȥեå
        // -------------------------------------------------
        $template_files = array('index');

        // -------------------------------------------------
        // ץȺ
        // -------------------------------------------------
        $this->c_project->trigger($project_dir);

        // -------------------------------------------------
        // ץꥱ
        // -------------------------------------------------
        if ($app_name) {
            $this->c_application->trigger($project_dir, $app_name);
        }

        // -------------------------------------------------
        // ȥե
        // -------------------------------------------------
        if ($controller_file) {
            $this->c_controller->trigger($project_dir, $app_name, $controller_file);
        }

        // -------------------------------------------------
        // ե
        // -------------------------------------------------
        if (count($action_files) > 0) {
            $this->c_action->trigger($project_dir, $app_name, $action_files);
        }

        // -------------------------------------------------
        // ƥץ졼ȥե
        // -------------------------------------------------
        if (count($template_files) > 0) {
            $this->c_template->trigger($project_dir, $app_name, $template_files);
        }
    }

}

?>
