<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: adm.php,v 1.2 2007/08/08 12:25:21 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

error_reporting(E_ALL);

// ʃvWFNg̐ݒt@C擾邽߂̏
$is_project_dir = false;
$is_app_name    = false;
$project_dir    = '';
$app_name       = '';
foreach ($argv as $arg) {
    if ($is_project_dir) {
        $project_dir    = $arg;
        $is_project_dir = false;
    }
    if ($is_app_name) {
        $app_name    = $arg;
        $is_app_name = false;
    }
    $is_project_dir = ($arg == '-d');
    $is_app_name    = ($arg == '-w');
}

if ((array_search('-v', $argv) === false) &&
    (array_search('-h', $argv) === false) &&
    (array_search('--version', $argv) === false) &&
    (array_search('--help',    $argv) === false)) {
    if (!$project_dir) {
        echo "[SyL error] Project directory not found.\nTry `php {$argv[0]} --help' for more information.\n";
        exit;
    }
    if (!$app_name) {
        echo "[SyL error] Application name not found.\nTry `php {$argv[0]} --help' for more information.\n";
        exit;
    }
}

$define_configs = array();
$define_configs[] = "{$project_dir}/app/{$app_name}/defines.xml";
$define_configs[] = "{$project_dir}/config/defines.xml";

$syl_dir = dirname(dirname(__FILE__));

require_once $syl_dir . '/SyL.php';

$config = array(
  'action_key' => 'action',
  'webapp_dir' => $syl_dir . '/opt/adm',
  'app_name'   => 'generate',
  'define'     => $define_configs,
  'debug'      => SYL_LOG_DEBUG
);

$controller =& SyL_Controller::getController($config);
$controller->stream();

?>
