<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowDel.php,v 1.2 2007/08/08 12:25:20 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եδ쥯饹
 */
require_once SYL_INCLUDE_DIR . '/framework/Adm/SyL_AdmFlow.php';

/**
 * ե饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowDel.php,v 1.2 2007/08/08 12:25:20 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_AdmFlowDel extends SyL_AdmFlow
{
    /**
     * ڥ졼̾
     *
     * @access protected
     * @var string
     */
    var $opp_name = 'del';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_AdmFlowDel()
    {
        parent::SyL_AdmFlow();
    }

    /**
     * ե
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȴ֥
     */
    function execute(&$data, &$context)
    {
        if ($context->isPost()) {
            // ե
            $form =& $this->getForm();
            // 祭ѥ᡼̾
            $key_name = $form->getStructConfig('key_name');
            // ѥ᡼
            $keys = $data->get($key_name);
            if (is_string($keys)) {
                $keys = array($keys);
            } else {
                $keys = $data->geta($key_name);
                if (!is_array($keys)) {
                    // Բ
                    SyL_Response::redirect($this->getUrl('lst'));
                }
            }

            // DB³
            $conn =& $this->getDB();
            // ADM֥Ⱥ
            $adm  =& SyL_Adm::factory($form, $conn, $keys);
            // ơ֥
            $adm->loadConfig();
            // å
            if (!$adm->isDel()) {
                // Բ
                SyL_Response::redirect($this->getUrl('lst'));
            }
            // ȥ󥶥󳫻
            $conn->beginTransaction();
            // ¹
            $adm->delete();
            // ȥ󥶥
            $conn->commit();
            // DB³λ
            $conn->closeConnection();

            // λ̤إ쥯
            SyL_Response::redirect($this->getUrl('fin') . '?__adm=del');
        } else {
            SyL_Response::redirect($this->getUrl('lst'));
        }
    }
}

?>
