<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DataWeb.php,v 1.4 2007/07/29 08:54:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ꥯȥǡݻ饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DataWeb.php,v 1.4 2007/07/29 08:54:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DataWeb extends SyL_Data
{
    /**
     * ѥ᡼get᥽åɤǼǤե饰
     *
     * @access protected
     * @var bool
     */
    var $input_get_array = false;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_DataWeb()
    {
        // ѥ᡼
        $this->setInputs(($_SERVER['REQUEST_METHOD'] == 'POST') ? $_POST + $_GET : $_GET + $_POST);
        // ޥåݥȤͭȽ
        if (get_magic_quotes_gpc()) {
            $this->apply('stripslashes');
        }
    }

    /**
     * ץѥƥ
     * 
     * @access public
     * @param string ץѥƥ̾
     * @return string ץѥƥ
     */
    function get($name)
    {
        $value = parent::get($name);
        if (!$this->input_get_array) {
            if (isset($this->input_parameters[$name]) && is_array($value) && ($this->input_parameters[$name] === $value)) {
                // ϥѥ᡼ϡgeta᥽åɤŪ˼
                $value = null;
            }
        }
        return $value;
    }

    /**
     * ץѥƥʻȡ
     * 
     * @access public
     * @param string ץѥƥ̾
     * @return string ץѥƥ
     */
    function &getRef($name)
    {
        $value =& parent::getRef($name);
        if (!$this->input_get_array) {
            if (isset($this->input_parameters[$name]) && is_array($value) && ($this->input_parameters[$name] === $value)) {
                // ϥѥ᡼ϡgeta᥽åɤŪ˼
                $value = null;
            }
        }
        return $value;
    }

    /**
     * ϥѥ᡼Ū˼
     * 
     * @access public
     * @param string ץѥƥ̾
     * @return array ץѥƥ
     */
    function geta($name)
    {
        if (isset($this->input_parameters[$name]) && is_array($this->input_parameters[$name])) {
            return $this->input_parameters[$name];
        } else {
            return null;
        }
    }

    /**
     * get᥽åѥ᡼ե饰򥻥å
     * 
     * @access public
     * @param bool ѥ᡼ե饰
     */
    function isGetArray($input_get_array = false)
    {
        $this->input_get_array = (bool)$input_get_array;
    }
}

?>
