<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorCmd.php,v 1.12 2007/05/27 16:24:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ޥɥ顼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorCmd.php,v 1.12 2007/05/27 16:24:29 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ErrorCmd extends SyL_Error
{
    /**
     * Ķ̥顼
     * 
     * @access public
     * @param array 顼å
     * @param array 顼ȥ졼
     */
    function displayError($error_messages, $error_trace)
    {
        // display_errorsoffξϥ顼̤ɽʤ
        if (!ini_get('display_errors')) {
            return;
        }

        // 顼å
        $error_message = implode($this->eol, $error_messages) . $this->eol;
        // 顼åɽ
        echo $error_message;
        if ($error_trace) {
            echo $this->eol;
            echo $this->getTraceConsole($error_trace);
        }
    }

    /**
     * 顼ȥ졼
     *
     * @access public
     * @return array 顼ȥ졼
     * @return string 顼ȥ졼
     */
    function getTraceConsole($error_trace)
    {
        $error_trace_result = '';
        if (count($error_trace) > 0) {
            // 顼ȥ졼ɽκ
            $error_trace_result .= "------ start Stack Trace ------" . $this->eol;
            foreach ($error_trace as $value) {
                $error_trace_result .= "{$value['no']}. [file] {$value['file']} [line] {$value['line']} [function] {$value['function']}" . $this->eol;
            }
            $error_trace_result .= "------ end Stack Trace ------" . $this->eol;
        }

        return $error_trace_result;
    }
}
?>
