<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ActionForm.php,v 1.5 2007/08/08 12:25:20 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ե९饹
 */
require_once SYL_INCLUDE_DIR . '/lib/SyL_Form.php';

/**
 * ե९饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ActionForm.php,v 1.5 2007/08/08 12:25:20 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ActionForm extends SyL_Form
{
    /**
     * ǽ
     * 
     * @access protected
     * @var string
     */
    var $type = '';
    /**
     * ơ֥륯饹
     * 
     * @access protected
     * @var array
     */
    var $table_classes = array();
    /**
     * ơ֥륯饹δϢ
     * 
     * @access protected
     * @var array
     */
    var $table_relations = array();
    /**
     * ᥤƥʥ󥹥ơ֥̾
     * 
     * @access protected
     * @var string
     */
    var $maintenance_table = '';
    /**
     * 
     * 
     * @access protected
     * @var array
     */
    var $structs_config = array();
    /**
     * ե
     * 
     * @access protected
     * @var array
     */
    var $elements_config = array();
    /**
     * SyL_Form饹ץѥƥ
     * 
     * @access protected
     * @var array
     */
    var $elements_config_etc = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string URL
     * @param string ǽ
     */
    function SyL_ActionForm($action='', $type='')
    {
        parent::SyL_Form($action);

        switch (strtolower($type)) {
        case 'lst': $this->type = 'lst'; break; // 
        case 'new': $this->type = 'new'; break; // 
        case 'upd': $this->type = 'upd'; break; // 
        case 'del': $this->type = 'del'; break; // 
        case 'vew': $this->type = 'vew'; break; // ܺɽ
        }
    }

    /**
     * ե᥽å
     *
     * @static
     * @access public
     * @param string ե४֥̾
     * @param string URL
     * @param string եൡǽ̾new, upd, del
     * @return object ե४֥
     */
    function &factory($formpath, $action='', $type='')
    {
        SyL_Loader::lib($formpath);
        $classname = SyL_Loader::convertClass($formpath);
        $form =& new $classname($action, $type);
        return $form;
    }

    /**
     * ǽפ
     *
     * @access public
     * @return string ǽ
     */
    function getType()
    {
        return $this->type;
    }

    /**
     * ǡ֥ȤΥХå᥽åɤϿ
     *
     * @access public
     * @param object ǡ֥
     */
    function registerInput(&$data)
    {
        // 
        $data->isGetArray(true);
        // ѥ᡼᥽åɥå
        $this->registerInputCallback(array(&$data, 'get'));
    }

    /**
     * Ǥ°ɲä
     *
     * @access public
     * @param string ̾
     * @param array °
     */
    function addConfig($name, $attributes)
    {
        $this->elements_config[$name] = $attributes;
    }

    /**
     * ơ֥륯饹ΥꥹȤ
     *
     * @access public
     * @return array ơ֥륯饹Υꥹ
     */
    function getTableClasses()
    {
        return $this->table_classes;
    }

    /**
     * ơ֥δϢ
     *
     * @access public
     * @return array ơ֥δϢ
     */
    function getTableRelations()
    {
        return $this->table_relations;
    }

    /**
     * ͤ
     *
     * @access public
     * @return mixed 
     */
    function getStructConfig($name)
    {
        return isset($this->structs_config[$name]) ? $this->structs_config[$name] : null;
    }

    /**
     * ᥤƥʥ󥹥ơ֥̾
     *
     * @access public
     * @return string ᥤƥʥ󥹥ơ֥̾
     */
    function getMaintenanceTable()
    {
        return $this->maintenance_table;
    }

    /**
     * ɽΥꥹȤ
     *
     * @access public
     * @param string ơ֥̾
     * @return array ɽΥꥹ
     */
    function getListColumns($alias='')
    {
        $i = 1;
        $lists = array();
        // ǰɽ롼
        foreach ($this->elements_config as $name => $values) {
            $sort = 0;
            // ɽȽ
            if ($alias && isset($values['alias']) && ($values['alias'] != $alias)) {
                // ̾פʤϼʤ
                continue;
            } else {
                switch ($this->type) {
                case 'lst':
                    if (isset($values['display_list']) && !$values['display_list']) {
                        // ɽǡɽե饰ɽξϼʤ
                        continue 2;
                    }
                    $sort = (isset($values['sort_list']) && $values['sort_list']) ? $values['sort_list'] : $i++;
                    break;
                case 'new':
                case 'upd':
                case 'vew':
                    if (isset($values['display_detail']) && !$values['display_detail']) {
                        // ܺɽǡɽե饰ɽξϼʤ
                        continue 2;
                    }
                    $sort = (isset($values['sort_detail']) && $values['sort_detail']) ? $values['sort_detail'] : $i++;
                    break;
                }
            }
            $lists[$sort] = $name;
        }
        ksort($lists, SORT_NUMERIC);
        return $lists;
    }

    /**
     * եѥ᡼å
     *
     * @access public
     * @param string ̾
     * @param array եѥ᡼
     */
    function build()
    {
        $i = 1;
        $elements = array();
        // Ͽ롼
        foreach ($this->elements_config as $name => $values) {
            if (isset($values['display_detail']) && !$values['display_detail']) {
                // ɽե饰ɽξϼʤ
                continue;
            }

            $type         = $values['type'];
            $display_name = isset($values['name'])       ? $values['name']       : $name;
            $options      = isset($values['options'])    ? $values['options']    : array();
            $attributes   = isset($values['attributes']) ? $values['attributes'] : array();
            // Ǻ
            $element =& $this->createElement($type, $name, $display_name, $options, $attributes);
            if (isset($values['validate']) && (count($values['validate']) > 0)) {
                if ((($this->type == 'new') && isset($values['read_only_new']) && $values['read_only_new']) ||
                    (($this->type == 'upd') && isset($values['read_only_upd']) && $values['read_only_upd'])) {
                    // ɤ߹ѤʤΤǡХǡɲäʤ
                    // ɤ߹ѥե饰ɲ
                    $element->setReadOnly(true);
                } else {
                    // Хǡɲ
                    $vs =& SyL_Validators::create();
                    foreach ($values['validate'] as $v_name => $v_values) {
                        $v_parameters = isset($v_values['parameters']) ? $v_values['parameters'] : array();
                        $vs->add(SyL_Validator::create($v_name, $v_values['message'], $v_parameters));
                    }
                    $element->setValidators($vs);
                }
            }

            $this->elements_config_etc[$name]['cols'] = isset($values['cols']) ? $values['cols'] : '1';
            $this->elements_config_etc[$name]['read_only_new'] = isset($values['read_only_new']) ? $values['read_only_new'] : false;
            $this->elements_config_etc[$name]['read_only_upd'] = isset($values['read_only_upd']) ? $values['read_only_upd'] : false;

            // Ƚ
            $sort = (isset($values['sort_detail']) && $values['sort_detail']) ? $values['sort_detail'] : $i++;
            // ¤ӽѹΤ¸
            $elements[$sort] =& $element;
        }

        ksort($elements, SORT_NUMERIC);
        foreach (array_keys($elements) as $name) {
            $this->addElement($elements[$name]);
        }
    }

    /**
     * եѥ᡼å
     *
     * @access public
     * @param string ̾
     * @param array եѥ᡼
     */
    function buildSearch()
    {
        if ($this->getStructConfig('enable_sch')) {
            // Ͽ롼
            foreach ($this->elements_config as $name => $values) {
                if (!isset($values['search']) || !$values['search']) {
                    // ɽե饰ɽξϼʤ
                    continue;
                }

                $type         = $values['type'];
                $display_name = isset($values['name'])       ? $values['name']       : $name;
                $options      = isset($values['options'])    ? $values['options']    : array();
                $attributes   = isset($values['attributes']) ? $values['attributes'] : array();
                // Ǻ
                $element =& $this->createElement($type, $name, $display_name, $options, $attributes);
                $this->addElement($element);
                $this->elements_config_etc[$name]['cols'] = '1'; // ϶Ū2
            }
        }
    }

    /**
     * ƤǤͤ
     *
     * @access public
     * @return array ƤǤ
     */
    function getValues($alias='')
    {
        $values = array();
        foreach (parent::getValues() as $name => $value) {
            if ((($this->type == 'new') && $this->elements_config_etc[$name]['read_only_new']) ||
                (($this->type == 'upd') && $this->elements_config_etc[$name]['read_only_upd'])) {
                // ɤ߹ѤʤΤǡϿܤ˴ޤʤ
                continue;
            }
            // ̾ե륿
            if ($alias && isset($this->elements_config[$name]['alias']) && ($this->elements_config[$name]['alias'] != $alias)) {
                continue;
            }
            $values[$name] = $value;
        }
        return $values;
    }

    /**
     * եǤǼ
     *
     * @access public
     * @return array եǤ
     */
    function &getResultArray()
    {
        // ƥ饹η̤
        $results =& parent::getResultArray();

        $cols        = '';
        $end_space   = false;
        $dummy_index = 1;
        $elements    = array();
        // Ѥ
        $element_space = array(
          'label'     => '&nbsp;',
          'html'      => '&nbsp;',
          'require'   => false,
          'read_only' => true,
          'cols'      => '1'
        );
        foreach (array_keys($this->results['elements']) as $name) {
            // ɽѹ
            $end_space = false;
            switch ($cols) {
            case '':
                // 
                $elements[$name] = $results['elements'][$name];
                $elements[$name]['cols'] = ($this->elements_config_etc[$name]['cols'] == '1') ? '0' : '2';
                break;
            case '0':
                if ($this->elements_config_etc[$name]['cols'] == '1') {
                    // 2α
                    $elements[$name] = $results['elements'][$name];
                    $elements[$name]['cols'] = '1';
                } else if ($this->elements_config_etc[$name]['cols'] == '2') {
                    // 2αǶ
                    $elements['__dummy_' . $dummy_index++] = $element_space;
                    // 1
                    $elements[$name] = $results['elements'][$name];
                    $elements[$name]['cols'] = '2';
                }
                break;
            case '1':
                $elements[$name] = $results['elements'][$name];
                if ($this->elements_config_etc[$name]['cols'] == '1') {
                    // 2κ
                    $elements[$name]['cols'] = '0';
                    $end_space = true;
                } else if ($this->elements_config_etc[$name]['cols'] == '2') {
                    // 1
                    $elements[$name]['cols'] = '2';
                }
                break;
            case '2':
                $elements[$name] = $results['elements'][$name];
                if ($this->elements_config_etc[$name]['cols'] == '1') {
                    // 2κ
                    $elements[$name]['cols'] = '0';
                    $end_space = true;
                } else if ($this->elements_config_etc[$name]['cols'] == '2') {
                    // 1
                    $elements[$name]['cols'] = '2';
                }
                break;
            }
            $cols = $elements[$name]['cols'];
        }

        if ($end_space) {
            // ɽ
            $elements['__dummy_' . $dummy_index++] = $element_space;
        }

        // Ǻƺ
        $this->results['elements'] = $elements;

        return $results;
    }


    /**
     * ǡ
     *
     * @access public
     * @return array ǡ
     */
    function getDataSources()
    {
        $result = array();
        foreach ($this->elements_config as $name => $elements_config) {
            if (isset($elements_config['data_source']) && $elements_config['data_source']) {
                $result[$name] = $elements_config['data_source'];
            }
        }
        return $result;
    }
}

?>
