/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * Хǡ󥨥顼Ǽ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id:$
 * @link      http://www.syl.jp/
 */
function SyL_FormErrors()
{
  // 顼ɽID
  this.id = null;
  // 顼ɽե饰
  this.displayAll = true;
  // 顼åإå
  this.error_message_header = '';
  // 顼åեå
  this.error_message_footer = '';
  // 顼ǳǼ
  this.errorElements = [];
  // 顼Ǽ
  this.errorMessages = [];
}

SyL_FormErrors.prototype = {
  /**
   * 顼ɽID򥻥åȤ
   *
   * @access public
   * @param string 顼ɽID
   */
  setDisplayElementId: function(id)
  {
    this.id = id;
  },
  /**
   * 顼ɽե饰򥻥åȤ
   *
   * @access public
   * @param bool true: 顼ɽfalse: 1ĤΥ顼ɽ
   */
  setDisplayAll: function(flag)
  {
    this.displayAll = flag;
  },
  /**
   * 顼åإå򥻥åȤ
   *
   * @access public
   * @param string 顼åإå
   */
  setHeader: function(message)
  {
    this.error_message_header = message;
  },
  /**
   * 顼åեå򥻥åȤ
   *
   * @access public
   * @param string 顼åեå
   */
  setFooter: function(message)
  {
    this.error_message_footer = message;
  },
  /**
   * 顼뤫Ƚꤹ
   *
   * @access public
   * @param string ̾
   * @return bool true: 顼, false: 顼̵
   */
  isError: function(name)
  {
    if (name) {
      for (var i=0; i<this.errorElements.length; i++) {
        if (this.errorElements[i] == name) {
          return true;
        }
      }
      return false;
    } else {
      return (this.errorMessages.length > 0);
    }
  },

  /**
   * 顼å򥻥åȤ
   *
   * @access public
   * @param string ̾
   * @param string 顼å
   */
  setErrorMessage: function(name, errorMessage)
  {
    for (var i=0; i<this.errorElements.length; i++) {
      if (this.errorElements[i] == name) {
        this.errorElements.splice(i, 1);
        this.errorMessages.splice(i, 1);
        break;
      }
    }
    this.errorElements.push(name);
    this.errorMessages.push(errorMessage);
  },

  /**
   * 顼å
   *
   * @access public
   * @return array 顼å
   */
  getErrorMessages: function()
  {
    return this.errorMessages;
  },

  /**
   * 顼åɽ
   *
   * @access public
   * @param object ե४֥
   */
  displayErrorMessage: function (form)
  {
    // 顼̵Ͻλ
    if (!this.isError()) {
      return;
    }

    // ̵trueξϡɽ
    var displayMessage = (this.displayAll) ? this.errorMessages.join("\n") : this.errorMessages.shift();
    displayMessage = this.error_message_header + displayMessage + this.error_message_footer;

    // 顼åɽ
    if (this.id) {
      document.getElementById(this.id).innerHTML = displayMessage.replace(new RegExp("(\r\n|\r|\n)", "g"), "<br>");
    } else {
      alert(displayMessage);
    }

    // ե
    if (form) {
      var name = this.errorElements.shift();
      this.focusElement(form, name);
      this.selectElement(form, name);
    }
  },

  /**
   * Ǥե
   *
   * @access public
   * @param string ̾
   */
  focusElement: function(form, name)
  {
    if (form.elements[name][0]) {
      form.elements[name][0].focus();
    } else {
      form.elements[name].focus();
    }
  },

  /**
   * Ǥ򤹤
   *
   * @access public
   * @param string ̾
   */
  selectElement: function(form, name)
  {
    switch (form.elements[name].type) {
    case "text":
    case "textarea":
    case "password":
    case "file":
      form.elements[name].select();
      break;
    }
  }
}
