<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AuthFile.php,v 1.3 2007/08/12 05:59:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եǧڥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AuthFile.php,v 1.3 2007/08/12 05:59:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_AuthFile extends SyL_Auth
{
    /**
     * 桼̾ѥɶڤʸ
     *
     * @access private
     * @var string
     */
    var $separater = ':';

    /**
     * ǧڼ¹
     * 
     * @access public
     * @return bool OK: ǧOK, NG: ǧNG
     */
    function doLogin()
    {
         $client_username = isset($_POST[$this->username]) ? $_POST[$this->username] : '';
         $client_password = isset($_POST[$this->password]) ? $_POST[$this->password] : '';

         clearstatcache();

         $passwd_file  = SYL_AUTH_TYPE_PARAMETER;
         $passwd_file1 = SYL_PROJECT_DIR . '/var/' . $passwd_file;
         if (!is_file($passwd_file1)) {
             if (!is_file($passwd_file)) {
                 trigger_error("[SyL error] Auth file not found ({$passwd_file} or {$passwd_file1})", E_USER_ERROR);
             }
             $passwd_file1 = $passwd_file;
         }
         if (!is_readable($passwd_file1)) {
             trigger_error("[SyL error] Auth file permission denied ({$passwd_file1})", E_USER_ERROR);
         }

         SyL_Loggers::info("[Auth] Password file: {$passwd_file1}");

         $server_password = null;
         foreach (file($passwd_file1) as $user) {
             $user = explode($this->separater, rtrim($user), 2);
             if ($user[0] && ($user[0] == $client_username)) {
                 $server_password = $user[1];
                 break;
             }
         }

         if ($server_password === null) {
             // ǧԲ
             $client_username = '';
             $server_password = '';
         }
         // ѥȽ
         return $this->isLoginPassword($client_username, $client_password, $server_password);
    }
}

?>
