<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSchemaMysql.php,v 1.2 2007/08/08 12:25:21 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * DB޼饹 (MySQL)
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSchemaMysql.php,v 1.2 2007/08/08 12:25:21 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBSchemaMysql extends SyL_DBSchema
{
    /**
     * ³ƤDBΥơ֥
     *
     * @access public
     * @return array ơ֥
     */
    function getTables()
    {
        $result = array();
        $version = $this->conn->getVersion();
        if ($version && version_compare($version, '5.0', '>=')) {
            $sql  = "";
            $sql .= "SELECT ";
            $sql .=   "TABLE_SCHEMA, ";
            $sql .=   "TABLE_NAME, ";
            $sql .=   "TABLE_TYPE ";
            $sql .= "FROM ";
            $sql .=   "INFORMATION_SCHEMA.TABLES ";
            $sql .= "WHERE ";
            $sql .=   "TABLE_SCHEMA <> 'information_schema'";
            foreach ($this->conn->query($sql) as $table) {
                $result[] = array(
                  'name'   => $table['TABLE_NAME'],
                  'schema' => $table['TABLE_SCHEMA'],
                  'owner'  => '',
                  'view'   => ($table['TABLE_TYPE'] == 'VIEW')
                );
            }
        } else {
            $sql = "show tables";
            foreach ($this->conn->query($sql) as $table) {
                $result[] = array(
                  'name'   => array_shift($table),
                  'schema' => '',
                  'owner'  => '',
                  'view'   => ''
                );
            }
        }

        return $result;
    }

    /**
     * ꤷơ֥Υ
     *
     * @access public
     * @param string ơ֥̾
     * @return array 
     */
    function getColumns($tablename)
    {
        $result = array();
        $sql = "show columns from {$tablename}";
        foreach ($this->conn->query($sql) as $column) {
            list($type, $min, $max) = $this->getFormat($column['TYPE']);
            $result[$column['FIELD']] = array(
              'type'     => $type,
              'min'      => $min,
              'max'      => $max,
              'primary'  => ($column['KEY'] == 'PRI'),
              'not_null' => (($column['KEY'] == 'PRI') || ($column['NULL'] == 'NO')),
              'default'  => (($column['DEFAULT'] != 'NULL') || ($column['EXTRA'] == 'auto_increment'))
            );
        }
        return $result;
    }

    /**
     * ෿Ф복׷
     *
     * @access private
     * @param string ෿
     * @return array ׷
     */
    function getFormat($type)
    {
        $type = strtolower($type);
        if (strpos($type, 'tinyint') === 0) {
            if (strpos($type, 'unsigned') !== false) {
                return array('I', '0', '255');
            } else {
                return array('I', '-128', '127');
            }
        } else if (strpos($type, 'smallint') === 0) {
            if (strpos($type, 'unsigned') !== false) {
                return array('I', '0', '65535');
            } else {
                return array('I', '-32768', '32767');
            }
        } else if (strpos($type, 'mediumint') === 0) {
            if (strpos($type, 'unsigned') !== false) {
                return array('I', '0', '16777215');
            } else {
                return array('I', '-8388608', '8388607');
            }
        } else if (strpos($type, 'int') === 0) {
            if (strpos($type, 'unsigned') !== false) {
                return array('I', '0', '4294967295');
            } else {
                return array('I', '-2147483648', '2147483647');
            }
        } else if (strpos($type, 'bigint') === 0) {
            if (strpos($type, 'unsigned') !== false) {
                return array('I', '0', '18446744073709551615');
            } else {
                return array('I', '-9223372036854775808', '9223372036854775807');
            }
        } else if ((strpos($type, 'float') === 0) ||
                   (strpos($type, 'double') === 0)) {
            return array('F', null, null);
        } else if (strpos($type, 'decimal') === 0) {
            if (preg_match('/decimal\((\d+),(\d+)\)/', $type, $matches)) {
                $i = str_repeat('9', $matches[1]);
                $f = str_repeat('9', $matches[2]);
                if (strpos($type, 'unsigned') !== false) {
                    return array('N', '0', "{$i}.{$f}");
                } else {
                    return array('N', "-{$i}.{$f}", "{$i}.{$f}");
                }
            } else {
                trigger_error("[SyL error] Invalid decimal type ({$type})", E_USER_ERROR);
            }
        } else if (strpos($type, 'date') === 0) {
            return array('D', '1000-01-01 00:00:00', '9999-12-31 23:59:59');
        } else if (strpos($type, 'time') === 0) {
            return array('T', '1000-01-01 00:00:00', '9999-12-31 23:59:59');
        } else if (strpos($type, 'datetime') === 0) {
            return array('DT', '1000-01-01 00:00:00', '9999-12-31 23:59:59');
        } else if (strpos($type, 'timestamp') === 0) {
            return array('DT', '1970-01-01 00:00:00', '2036-12-31 23:59:59');
        } else if (strpos($type, 'year') === 0) {
            return array('I', '1901', '2155');
        } else if (strpos($type, 'char') === 0) {
            if (preg_match('/char\((\d+)\)/', $type, $matches)) {
                return array('S', '0', "{$matches[1]}");
            } else {
                trigger_error("[SyL error] Invalid char type ({$type})", E_USER_ERROR);
            }
        } else if (strpos($type, 'varchar') === 0) {
            if (preg_match('/varchar\((\d+)\)/', $type, $matches)) {
                return array('S', '0', "{$matches[1]}");
            } else {
                trigger_error("[SyL error] Invalid char type ({$type})", E_USER_ERROR);
            }
        } else if ((strpos($type, 'tinyblob') === 0) ||
                   (strpos($type, 'tinytext') === 0)) {
            return array('S', '0', '255');
        } else if ((strpos($type, 'blob') === 0) ||
                   (strpos($type, 'text') === 0)) {
            return array('S', '0', '65535');
        } else if ((strpos($type, 'mediumblob') === 0) ||
                   (strpos($type, 'mediumtext') === 0)) {
            return array('S', '0', '16777215');
        } else if ((strpos($type, 'longblob') === 0) ||
                   (strpos($type, 'longtext') === 0)) {
            return array('S', '0', '4294967295');
        } else {
            return array('S', null, null);
        }
    }

}

?>
