<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSchema.php,v 1.2 2007/08/08 12:25:20 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * DB޼饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSchema.php,v 1.2 2007/08/08 12:25:20 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBSchema
{
    /**
     * DB֥
     * 
     * @access protected
     * @var object
     */
    var $conn = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param object DB֥
     */
    function SyL_DBSchema(&$conn)
    {
        $this->conn =& $conn;
    }

    /**
     * DB޼֥Ⱥ
     *
     * @access public
     * @param object DB֥
     * @return object DB޼֥
     */
    function &factory(&$conn)
    {
        switch (strtolower($conn->dbname)) {
        case 'mysql':
        case 'mysqli':
        case 'pdomysql':
            $type = 'Mysql';
            break;
        case 'pgsql':
        case 'pdopgsql':
            $type = 'Pgsql';
            break;
        default:
            trigger_error("[SyL error] Unsupported DB type ({$type})", E_USER_ERROR);
        }
        
        $classname = "SyL_DBSchema{$type}";
        include_once dirname(__FILE__) . "/Schema/{$classname}.php";
        $schema =& new $classname($conn);
        return $schema;
    }

    /**
     * ³ƤDBΥơ֥
     *
     * @access public
     * @return array ơ֥
     */
    function getTables()
    {
    }

    /**
     * ꤷơ֥Υ
     *
     * @access public
     * @param string ơ֥̾
     * @return array 
     */
    function getColumns($tablename)
    {
    }
}

?>
