<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDao.php,v 1.5 2007/08/12 05:59:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * SQL饹
 */
require_once 'SyL_DBSqlTableConditions.php';
/**
 * SQLϢ饹
 */
require_once 'SyL_DBSqlTableRelations.php';

/**
 * DBѥǡ饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDao.php,v 1.5 2007/08/12 05:59:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBDao
{
    /**
     * DB֥
     *
     * @access protected
     * @var object
     */
    var $conn = null;
    /**
     * ޥ֥Ȥ
     *
     * @access protected
     * @var array
     */
    var $tables = array();
    /**
     * ڡ
     *
     * @access protected
     * @var int
     */
    var $page = 0;
    /**
     * ڡ
     *
     * @access protected
     * @var int
     */
    var $limit = 10;
    /**
     * ڡ饹
     *
     * @access protected
     * @var object
     */
    var $pager = null;
    /**
     * SELECT
     *
     * @access private
     * @var array
     */
    var $select_headers = array();
    /**
     * ORDER BY
     *
     * @access private
     * @var array
     */
    var $sort_columns = array();
    /**
     * Ϣ³DML˥顼ȯ硢
     * ߤե饰
     *
     * @access protected
     * @var bool
     */
    var $error_stop = true;
    /**
     * 顼å
     *
     * @access protected
     * @var array
     */
    var $error_messages = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param object DB֥
     */
    function SyL_DBDao(&$conn)
    {
        $this->conn =& $conn;
    }

    /**
     * ơ֥索֥Ⱥ
     *
     * @access public
     * @return object 索֥
     */
    function createCondition()
    {
        return new SyL_DBSqlTableConditions();
    }

    /**
     * ơ֥Ϣ֥Ⱥ
     *
     * @access public
     * @return object Ϣ֥
     */
    function createRelation()
    {
        return new SyL_DBSqlTableRelations();
    }

    /**
     * SELECTܤ
     *
     * @access public
     * @return array SELECT
     */
    function getSelectHeaders()
    {
        return $this->select_headers;
    }

    /**
     * ȹܤ
     *
     * @access public
     * @return array ȹ
     */
    function getSortColumns()
    {
        return $this->sort_columns;
    }

    /**
     * ڡɽѥ᡼򥻥å
     *
     * @access public
     * @param int ɽڡ
     * @param int 1ڡη
     */
    function setPage($page=1, $limit=20)
    {
        $this->page  = $page;
        $this->limit = $limit;
    }

    /**
     * ڡ֥Ȥ
     *
     * @access public
     * @return object ڡ֥
     */
    function &getPager()
    {
        return $this->pager;
    }

    /**
     * DBǡ
     *
     * @access public
     * @param object or array ơ֥륪֥ 
     * @param object Ϣ֥
     * @return array ǡ
     */
    function select($table, $relation=null)
    {
        // ѤѴ
        $table = $this->arrangeTables($table);

        $selects   = array();
        $froms     = array();
        $wheres    = array();
        $group_bys = array();
        $order_bys = array();
        $this->select_headers = array();
        foreach(array_keys($table) as $name) {
            $selects    = array_merge($selects, $table[$name]->getSelectColumns($this->conn));
            $froms      = array_merge($froms, (array)$table[$name]->getSelectName());
            $conditions = $table[$name]->getConditions();
            if ($conditions) {
                $where = $conditions->getWhere($this->conn);
                if ($where) {
                    $wheres[] = $where;
                }
            }
            $group_bys  = array_merge($group_bys, $table[$name]->getGroups());
            $order_bys  = array_merge($order_bys, $table[$name]->getSorts());
            // SELECTݻ
            $this->select_headers = array_merge($this->select_headers, $table[$name]->getSelectHeaders());
        }

        // Ϣ糧å
        $from = '';
        if (is_object($relation)) {
            $join = $relation->getJoin();
            if ($join) {
                $from = $join;
            }
        }
        if (!$from) {
            $from = implode(', ', $froms);
        }
        $where    = implode(' AND ', $wheres);
        $group_by = implode(', ', $group_bys);
        $order_by = implode(', ', $order_bys);
        // ȥȥݻ
        $this->sort_columns = str_replace(' ', '.', $order_bys);

        $sql  = "";
        $sql .= "SELECT ";
        $sql .=   implode(', ', $selects) . " ";
        $sql .= "FROM ";
        $sql .=   $from . " ";
        if ($where) {
        $sql .= "WHERE ";
        $sql .=   $where . " ";
        }
        if ($group_by) {
        $sql .= "GROUP BY ";
        $sql .=   $group_by . " ";
        }
        if ($order_by) {
        $sql .= "ORDER BY ";
        $sql .=   $order_by . " ";
        }

//echo $sql;
//exit;

        if ($this->page === 0) {
            // ̾
            return $this->conn->query($sql);
        } else {
            // ڡ󥰤
            $this->conn->queryPageRef($sql, $result, $this->pager, $this->limit, $this->page);
            return $result;
        }
    }

    /**
     * DBϿ
     *
     * @access public
     * @param mixed ơ֥륪֥
     * @return bool true: OK, false: 顼
     */
    function insert($table)
    {
        // ѤѴ
        $table = $this->arrangeTables($table);
        // INSERT¹
        return $this->exec($table, 'insert');
    }

    /**
     * DB򹹿
     *
     * @access public
     * @param mixed ơ֥륪֥
     * @return bool true: OK, false: 顼
     */
    function update($table)
    {
        // ѤѴ
        $table = $this->arrangeTables($table);
        // UPDATE¹
        return $this->exec($table, 'update');
    }

    /**
     * DB
     *
     * @access public
     * @param mixed ơ֥륪֥
     * @return bool true: OK, false: 顼
     */
    function delete($table)
    {
        // ѤѴ
        $table = $this->arrangeTables($table);
        // DELETE¹
        return $this->exec($table, 'delete');
    }

    /**
     * ơ֥륪֥Ȥѥ᡼ѤѴ
     *
     * @access private
     * @param mixed ơ֥륪֥
     * @param string ơ֥Υꥢ̾
     */
    function arrangeTables($table)
    {
        $result = array();
        // ơ֥륪֥Ȥξ
        if (is_object($table)) {
            $alias = $table->getAliasName();
            $result[$alias] = $table;
        } else if (is_array($table)) {
            foreach ($table as $tmp) {
                $result += $this->arrangeTables($tmp);
            }
        }
        return $result;
    }

    /**
     * DBϿѤ˥
     *
     * @access private
     * @param array ơ֥륪֥
     * @param string insert or update or delete
     * @return bool true: OKfalse: 顼
     */
    function exec($table, $action)
    {
        $result = true;
        foreach (array_keys($table) as $name) {
            $conditions = $table[$name]->getConditions(false);
            $where      = ($conditions) ? $conditions->getWhere($this->conn) : '';
            if (!$this->conn->execPerform($table[$name]->getName(), $table[$name]->getDataColumns(), $action, $where)) {
                $result = false;
                $this->error_messages[] = $this->conn->errorInfo();
                if ($this->error_stop) {
                    break;
                }
            }
        }
        return $result;
    }

    /**
     * 顼Ƚꤹ
     *
     * @access public
     * @return bool true: 顼, false: 顼ʤ
     */
    function isError()
    {
        return (count($this->error_messages) > 0);
    }

    /**
     * 顼åƼ
     *
     * @access public
     * @return array 顼å
     */
    function getErrors()
    {
        return $this->error_messages;
    }

}

?>
