<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlParser.php,v 1.3 2007/04/30 13:15:57 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

if (!defined('SYL_ENCODE_XML')) {
    define('SYL_ENCODE_XML', 'UTF-8');
}

/**
 *  XMLѡ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlParser.php,v 1.3 2007/04/30 13:15:57 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlParser
{
    /**
     * եѡե饰
     *
     * @access private
     * @var bool
     */
    var $file_parse_flag = false;
    /**
     * ǡ or եѥ or URL
     *
     * @access private
     * @var string
     */
    var $resource = '';
    /**
     * XMLʸ
     *
     * @access private
     * @var string
     */
    var $xml_encode = SYL_ENCODE_XML;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_XmlParser()
    {
    }

    /**
     * XMLǡ򥻥å
     *
     * @access public
     * @param string XMLǡ
     */
    function setData($data)
    {
        $this->resource = $data;
        $this->file_parse_flag = false;
    }

    /**
     * XMLե򥻥å
     *
     * @access public
     * @param string XMLե
     */
    function setFile($filename)
    {
        if (!file_exists($filename)) {
            trigger_error("[SyL error] Xml file not found ({$filename})", E_USER_ERROR);
        }
        $this->resource = $filename;
        $this->file_parse_flag = true;
    }

    /**
     * XMLե򥻥å
     *
     * @access public
     * @param string URL
     */
    function setUrl($url)
    {
        $this->resource = $url;
        $this->file_parse_flag = true;
    }

    /**
     * XMLեΥ󥳡ɤ򥻥å
     *
     * @access public
     * @param string 󥳡̾
     */
    function setXmlEncode($xml_encode)
    {
        $this->xml_encode = $xml_encode;
    }

    /**
     * XMLեβϽ
     *
     * @access private
     */
    function parseXml()
    {
        // XMLѡ ʸUTF-8
        $parser = xml_parser_create($this->xml_encode);
        // ʸѴԤʤ
        xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, false);
        // ϥɥ᥽åɤ򥯥饹᥽åɤ
        xml_set_object($parser, $this);
        // start  end ǤΥϥɥꤹ
        xml_set_element_handler($parser,
          array(&$this, 'startElement'),
          array(&$this, 'endElement'  )
        );
        // ʸǡϥɥꤹ
        xml_set_character_data_handler($parser, array(&$this, 'characters'));
        // ǥեȥϥɥꤹ
        xml_set_default_handler($parser, array(&$this, 'defaults'));

        if ($this->file_parse_flag) {
            // XMLե륪ץ
            if (($fp = @fopen($this->resource, 'r')) == false) {
                trigger_error("[SyL error] Can't open xml file({$this->resource})", E_USER_ERROR);
            }
            while (!feof($fp)) {
                // XMLϽ
                $data = fread($fp, 4096);
                $this->parse($parser, $data, feof($fp));
            }
            // XMLե륯
            fclose($fp);
        } else {
            // XMLϽ
            $this->parse($parser, $this->resource, true);
        }
        // XMLѡγ 
        xml_parser_free($parser);
    }

    /**
     * XMLϽ
     *
     * @access private
     */
    function parse(&$parser, &$data, $eof)
    {
        // XMLѡ
        if (!xml_parse($parser, $data, $eof)){
            // ѡ顼
            trigger_error(
              sprintf("[SyL error] XML parse error: %s at %s (%d)",
                xml_error_string(xml_get_error_code($parser)),
                ($this->file_parse_flag ? $this->resource : 'Received DATA'),
                xml_get_current_line_number($parser)
              ),
              E_USER_ERROR
            );
        }
    }

    /**
     * ȳϤμ¹Խ
     *
     * @access public
     * @param resource XMLѡ
     * @param string ̾
     * @param array Ȥ°
     */
    function startElement(&$parser, $name, $attr) {}

    /**
     * Ƚλμ¹Խ
     *
     * @access public
     * @param resource XMLѡ
     * @param string ̾
     */
    function endElement(&$parser, $name) {}

    /**
     * 饯Ȥμ¹Խ
     *
     * @access public
     * @param resource XMLѡ
     * @param string ʸ
     */
    function characters(&$parser, $text) {}

    /**
     * ǥեȥϥɥ¹Խ
     *
     * @access public
     * @param resource XMLѡ
     * @param string ʸ
     */
    function defaults(&$parser, $data) {}
}

?>
