<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AuthBasic.php,v 1.5 2007/09/02 14:40:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ǧڥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AuthBasic.php,v 1.5 2007/09/02 14:40:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_AuthBasic extends SyL_Auth
{
    /**
     * ١åǧڤʸ
     *
     * @access private
     * @var string
     */
    var $realm = 'SyL Authentication Area';

    /**
     * 󥢥Ƚ
     * 
     * @access public
     * @return bool true: 󥢥󤢤ꡢfalse: 󥢥ʤ
     */
    function isLoginAction()
    {
        // å
        if ($this->isLogin()) {
            return false;
        }

        // ѥ᡼Ƚ
        if (isset($_SERVER['PHP_AUTH_USER']) && ($_SERVER['PHP_AUTH_USER'] !== '')) {
            SyL_Loggers::info("[Auth] Login Action: true");
            return true;
        } else {
            SyL_Loggers::info("[Auth] Login Action: false");
        }

        // ١åǧɽ
        SyL_Response::setHeader('WWW-Authenticate', 'Basic realm="' . $this->realm . '"');
        SyL_Response::setStatusHeader('401');

        $version = SYL_VERSION;
        $redirect_url = call_user_func(array(__CLASS__, 'getAuthSessionErrorUrl'));
        $data = <<<HTML
<html>
<head>
<meta http-equiv="Refresh" content="0;URL={$redirect_url}?login=false">
<title>401 authorization required (SyL Framework {$version})</title>
</head>
<body>
</body>
</html>
HTML;

        $response =& SyL_Response::singleton();
        $response->display($data);
        exit;
    }

    /**
     * ǧڼ¹
     * 
     * @access public
     * @return bool OK: ǧOK, NG: ǧNG
     */
    function doLogin()
    {
        // REQUEST_METHODŪѹ
        $request_method = $_SERVER['REQUEST_METHOD'];

        list($id, $passwd) = $this->getLoginParameterName();
        $_SERVER['REQUEST_METHOD'] = 'POST';
        $_POST[$id]     = isset($_SERVER['PHP_AUTH_USER']) ? $_SERVER['PHP_AUTH_USER'] : '';
        $_POST[$passwd] = isset($_SERVER['PHP_AUTH_PW'])   ? $_SERVER['PHP_AUTH_PW']   : '';

        list(,$type) = explode(':', SYL_AUTH_TYPE, 2);
        $auth =& SyL_Auth::singleton($type);
        $auth->setUserParamaterName($id);
        $auth->setPasswordParamaterName($passwd);
        $result = $auth->doLogin();

        $_SERVER['REQUEST_METHOD'] = $request_method;
        return $result;
    }
}

?>
