<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Auth.php,v 1.7 2007/09/02 14:40:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 桼饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_User.php';

/**
 * ǧڥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Auth.php,v 1.7 2007/09/02 14:40:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Auth
{
    /**
     * å󥪥֥
     * 
     * @access private
     * @var object
     */
    var $session = null;
    /**
     * å̾
     * 
     * @access private
     * @var string
     */
    var $session_name = '';
    /**
     * ͤ򥻥åȤ륻åѿ̾
     *
     * @access private
     * @var string
     */
    var $challenge_response_session_name = 'syl_auth_challenge';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_Auth()
    {
    }

    /**
     * SyL_Auth饹Υ󥹥󥹼
     *
     * @access public
     * @param string ǧڥ
     * @return object ǧڥ֥
     */
    function &singleton($type='')
    {
        static $singleton = array();
        if (!$type) {
            list($type) = explode(':', SYL_AUTH_TYPE, 2);
        }

        if (!isset($singleton[$type])) {
            SyL_Loggers::info("[Auth] Create Auth Type: {$type}");

            $classname = 'SyL_Auth' . ucfirst($type);
            include_once SYL_INCLUDE_DIR . "/framework/Auth/{$classname}.php";
            // ǧڥ֥Ⱥ
            $singleton[$type] = new $classname();
            // 桼饹
            $classname = SYL_AUTH_USER_CLASS ? SyL_Loader::convertClass(SYL_AUTH_USER_CLASS, true) : 'SyL_User';
            // å󥪥֥ȥå
            $request =& SyL_Request::singleton();
            $singleton[$type]->setSessionObject($request->getSessionObject());
            // å̾å
            $singleton[$type]->setSessionName($classname);
            $user = $singleton[$type]->getUser();
            // 桼֥ȤƤʤޤϥ󤷤Ƥʤк
            if (!$user) {
                $singleton[$type]->setUser(new $classname());
            }
        }
        return $singleton[$type];
    }

    /**
     * å󥪥֥Ȥ򥻥åȤ
     * 
     * @access private
     * @param object å󥿥
     */
    function setSessionObject(&$session)
    {
        $this->session =& $session;
    }

    /**
     * å̾򥻥å
     * 
     * @access private
     * @param string å̾
     */
    function setSessionName($session_name)
    {
        $this->session_name = $session_name;
    }

    /**
     * 桼֥ȼ
     * 
     * @access public
     * @return object 桼֥
     */
    function getUser()
    {
        return $this->session->get($this->session_name);
    }

    /**
     * 桼֥Ȥ򥻥å
     * 
     * @access public
     * @param object 桼֥
     */
    function setUser($user)
    {
        return $this->session->set($this->session_name, $user);
    }

    /**
     * ѥ᡼̾
     * 
     * @access public
     * @return array ѥ᡼
     */
    function getLoginParameterName()
    {
        $user = $this->getUser();
        return array($user->getUserIdParamaterName(), $user->getPasswordParamaterName());
    }

    /**
     * ǧڥꥢȽ
     * 
     * @access public
     * @return bool true: ǧڥꥢfalse: ǧڥꥢ
     */
    function isAuthArea()
    {
        $session_error_url = call_user_func(array(__CLASS__, 'getAuthSessionErrorUrl'));
        if ($_SERVER['PHP_SELF'] == $session_error_url) {
            return false;
        }

        $request_uri = isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : '/';
        $auth_url    = call_user_func(array(__CLASS__, 'getAuthUrl'));
        return (bool)preg_match('/^' . preg_quote($auth_url, '/') . '/', $request_uri);
    }

    /**
     * 󥢥Ƚ
     * 
     * @access public
     * @return bool true: 󥢥󤢤ꡢfalse: 󥢥ʤ
     */
    function isLoginAction()
    {
        list($id, $passwd) = $this->getLoginParameterName();
            SyL_Loggers::info("[Auth] a: $id, $passwd");
        if (($_SERVER['REQUEST_METHOD'] == 'POST') && isset($_POST[$id]) && isset($_POST[$passwd])) {
            SyL_Loggers::info("[Auth] Login Action: true");
            return true;
        } else {
            SyL_Loggers::info("[Auth] Login Action: false");
            return false;
        }
    }

    /**
     * ǧڼ¹
     * 
     * @access public
     * @return bool OK: ǧOK, NG: ǧNG
     */
    function doLogin()
    {
        return false;
    }

    /**
     * ǧڥѥȽ
     * 
     * @access protected
     * @param string 饤桼̾
     * @param string 饤ѥ
     * @param string С¦ѥ
     * @param string С¦ϥå岽ˡ
     * @return bool OK: ǧOK, NG: ǧNG
     */
    function isLoginPassword($client_username, $client_password, $server_password)
    {
        if (!$this->isLoginAction()) {
            SyL_Loggers::warn("[Auth] Login Failed. No Login Action. (class: " . get_class($this) . " user: {$client_username} hash: " . SYL_AUTH_PASSWORD_HASH . ")");
            return false;
        }
        if (($client_username === null) || ($client_username === '')) {
            SyL_Loggers::warn("[Auth] Login Failed. Empty UserName. (class: " . get_class($this) . " user: {$client_username} hash: " . SYL_AUTH_PASSWORD_HASH . ")");
            return false;
        }

        // ѥɥϥå岽
        $hashes = array_map('trim', explode(':', SYL_AUTH_PASSWORD_HASH));
        if ((count($hashes) == 2) && ($hashes[0] || $hashes[1])) {
            $challenge = $this->getChallengeCode();
            if ($hashes[0] && $hashes[1]) {
                //  饤ȡʥϥå -> Сʥϥå
                //    => Τޤ
                if ($challenge) {
                    // - 󥸤
                    //  CL: md5(  md5(ѥ))
                    //  SV: ѥ == md5(  ѥ)
                    SyL_Loggers::info("[Auth] Auth hash CL: {$hashes[0]} SV: {$hashes[1]} challenge: on");
                    $server_password = call_user_func($hashes[0], $challenge . $server_password);
                } else {
                    // - 󥸤ʤ
                    //  CL: md5(ѥ)
                    //  SV: ѥ == ѥ
                    SyL_Loggers::info("[Auth] Auth hash CL: {$hashes[0]} SV: {$hashes[1]} challenge: off");
                }
            } else if ($hashes[0]) {
                //  饤ȡʥϥå -> Сʿ
                //    => С¦ѥɤϥå岽
                if ($challenge) {
                    // - 󥸤
                    //  CL: md5(  md5(ѥ))
                    //  SV: ѥ == md5(  md5(ѥ))
                    SyL_Loggers::info("[Auth] Auth hash CL: {$hashes[0]} SV: (none) challenge: on");
                    $server_password = call_user_func($hashes[0], $server_password);
                    $server_password = call_user_func($hashes[0], $challenge . $server_password);
                } else {
                    // - 󥸤ʤ
                    //  CL: md5(ѥ)
                    //  SV: ѥ == md5(ѥ)
                    SyL_Loggers::info("[Auth] Auth hash CL: {$hashes[0]} SV: (none) challenge: off");
                    $server_password = call_user_func($hashes[0], $server_password);
                }
            } else if ($hashes[1]) {
                //  饤ȡʿ -> Сʥϥå
                //    => ѥɤϥå岽
                //  CL: ʤ
                //  SV: md5(ѥ)  == ѥ
                SyL_Loggers::info("[Auth] Auth hash CL: (none) SV: {$hashes[1]} challenge: off");
                $client_password = call_user_func($hashes[1], $client_password);
            } else {
                trigger_error("[SyL error] Unknown auth error", E_USER_ERROR);
            }
        } else {
            //  饤ȡʿ -> Сʿ
            //    => Τޤ
            //  CL: ʤ
            //  SV: ѥ == ѥ
            SyL_Loggers::info("[Auth] Auth hash CL: (none) SV: (none) challenge: off");
        }

        // 桼֥ȼ
        $user = $this->getUser();
        if ($server_password === $client_password) {
            SyL_Loggers::info("[Auth] Login Success. (class: " . get_class($this) . " user: {$client_username})");
            // 桼IDå
            $user->setUserId($client_username);
            // OK٥
            $user->triggerLoginSuccess();
            $this->setUser($user);
            return true;
        } else {
            SyL_Loggers::warn("[Auth] Login Failed. Invalid Password. (class: " . get_class($this) . " user: {$client_username})");
            // 󥨥顼٥
            $user->triggerLoginFailed();
            $this->setUser($user);
            return false;
        }
    }

    /**
     * ǧڥå
     * 
     * @access public
     * @return bool OK: ǧOK, NG: ǧNG
     */
    function isLogin()
    {
        $user = $this->getUser();
        return $user->isLogin();
    }

    /**
     * ǧں
     * 
     * @access public
     */
    function deleteLogin()
    {
        $this->setUser(null);
    }

    /**
     * ȽԤ
     * 
     * @access public
     * @return boolean OK: true, NG: false
     */
    function doLogout()
    {
        $user = $this->getUser();
        $client_username = $user->getUserId();
        SyL_Loggers::info("[Auth] Logout Success. (class: " . get_class($this) . " user: {$client_username})");
        // ȥ٥
        $user->triggerLogout();
        $this->deleteLogin();
        session_destroy();
    }

    /**
     * 󥸥ɤå˥åȤơ
     * 
     * @access public
     * @param string 󥸥ɤη
     * @return string 󥸥
     */
    function createChallengeCode($len=8)
    {
        $challenge = '';
        for ($i=0; $i<$len; $i++) {
            $challenge .= chr(mt_rand(48, 126));
        }
        $challenge = str_replace('\\', '_', $challenge); // \ ֤
        $this->session->set($this->challenge_response_session_name, $challenge);
        return $challenge;
    }

    /**
     * 󥸥ɤ
     * 
     * @access public
     * @return string 󥸥
     */
    function getChallengeCode()
    {
        $challenge = $this->session->get($this->challenge_response_session_name);
        return $challenge;
    }

    /**
     * TOPURL
     * 
     * @static
     * @access public
     */
    function getAuthUrl()
    {
        $request_uri = isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : '';
        $script_name = isset($_SERVER['SCRIPT_NAME']) ? $_SERVER['SCRIPT_NAME'] : '';
        if ($request_uri && $script_name) {
            if (preg_match ('/^' . preg_quote($script_name, '/') . '/', $request_uri)) {
                return $script_name . SYL_AUTH_PATHINFO;
            } else {
                // ĥҤ̵б
                $path_parts = pathinfo($script_name);
                if (isset($path_parts['extension'])) {
                    $path_parts['basename'] = basename($script_name, '.' . $path_parts['extension']);
                }
                if ($path_parts['dirname'] == '/') {
                    $path_parts['dirname'] = '';
                }
                return $path_parts['dirname'] . '/' . $path_parts['basename'] . SYL_AUTH_PATHINFO;
            }
        } else {
            trigger_error("[SyL error] Unable to get env(_SERVER['REQUEST_URI'] or _SERVER['SCRIPT_NAME'])", E_USER_ERROR);
        }
    }

    /**
     * å󥨥顼̤إ쥯
     * 
     * @static
     * @access public
     * @param string ɲåꥹȥ
     */
    function redirectTop($query_string='')
    {
        if ($query_string) {
            $query_string = '?' . $query_string;
        }
        SyL_Response::redirect(call_user_func(array(__CLASS__, 'getAuthUrl')) . $query_string);
    }

    /**
     * 󥨥顼URL
     * 
     * @static
     * @access public
     */
    function getAuthLoginErrorUrl()
    {
        if (SYL_AUTH_LOGIN_ERROR_URL) {
            return SYL_AUTH_LOGIN_ERROR_URL;
        } else {
            trigger_error("[SyL error] Define `SYL_AUTH_LOGIN_ERROR_URL' not value");
        }
    }

    /**
     * 󥨥顼̤إ쥯
     * 
     * @static
     * @access public
     */
    function redirectLoginError()
    {
        SyL_Response::redirect(call_user_func(array(__CLASS__, 'getAuthLoginErrorUrl')));
    }

    /**
     * å󥨥顼URL
     * 
     * @static
     * @access public
     */
    function getAuthSessionErrorUrl()
    {
        if (SYL_AUTH_SESSION_ERROR_URL) {
            return SYL_AUTH_SESSION_ERROR_URL;
        } else {
            trigger_error("[SyL error] Define `SYL_AUTH_SESSION_ERROR_URL' not value");
        }
    }

    /**
     * å󥨥顼̤إ쥯
     * 
     * @static
     * @access public
     */
    function redirectSessionError()
    {
        SyL_Response::redirect(call_user_func(array(__CLASS__, 'getAuthSessionErrorUrl')));
    }
}

?>
