<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowNew.php,v 1.3 2007/09/29 09:10:39 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եδ쥯饹
 */
require_once SYL_INCLUDE_DIR . '/framework/Adm/SyL_AdmFlow.php';

/**
 * ե饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowNew.php,v 1.3 2007/09/29 09:10:39 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_AdmFlowNew extends SyL_AdmFlow
{
    /**
     * ڥ졼̾
     *
     * @access protected
     * @var string
     */
    var $opp_name = 'new';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_AdmFlowNew()
    {
        parent::SyL_AdmFlow();
    }

    /**
     * ɽ
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȴ֥
     */
    function execute(&$data, &$context)
    {
        // ե
        $form =& $this->getForm();
        // DB³
        $conn =& $this->getDB();
        // ADM֥Ⱥ
        $adm  =& SyL_Adm::factory($form, $conn);
        // ơ֥
        $adm->loadConfig();
        // å
        if (!$adm->isNew()) {
            // Բ
            SyL_Response::redirect($this->getUrl('lst'));
        }

        // ǡ֥ȥå
        $form->registerInput($data);
        // ե๽
        $form->build();

        // ʬ
        if ($context->isPost()) {
            // ؿʤ
            if ($data->get('__adm_next')) {
                // Хǡ¹
                if ($adm->validate()) {
                    // ǧ̤
                    $form->setReadOnly(true);
                }
            } else if ($data->get('__adm_exe')) {
                // Хǡ¹
                if ($adm->validate()) {
                    // Ͽ¹
                    $adm->insert();
                    // λ̤إ쥯
                    SyL_Response::redirect($this->getUrl('fin') . '?__adm=new');
                }
            } else if ($data->get('__adm_prev')) {
                // ǧ̤
            }
        } else {
            // ɽ
        }

        // DB³λ
        $conn->closeConnection();

        // եǥǡ
        $data->set('form', $form->getResultArray());
        // ǧɽϢ
        $data->set('view_alert',   $form->getStructConfig('view_alert'));
        $data->set('view_confirm', $form->getStructConfig('view_confirm'));
        // ɽѥѥ᡼Ѥ
        $data->set('page', $data->get('page'));
        $data->set('sort', $data->get('sort'));

        // ʸϢ
        $data->set('title', $form->getStructConfig('title'));

        // URL
        $data->set('url_lst', $this->getUrl('lst'));
        $data->set('url_new', $this->getUrl('new'));
        $data->set('url_up',  $this->getUpUrl());
        $data->set('url_dir', dirname($this->getScriptName()));
    }

}

?>
