<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Adm.php,v 1.1 2007/07/29 08:55:00 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ̥쥤䡼ǡ饹 - 
 */
require_once SYL_INCLUDE_DIR . '/framework/Adm/SyL_AdmOperation.php';

/**
 * ̥쥤䡼ǡ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Adm.php,v 1.1 2007/07/29 08:55:00 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Adm
{
    /**
     * ADM֥Ȥ
     *
     * @static
     * @access public
     * @param object ե४֥
     * @param object DB֥
     * @param array 祭
     * @return object ADM֥
     */
    function &factory(&$form, &$conn, $keys=array())
    {
        $classname = 'SyL_AdmOperation' . ucfirst($form->getType());
        $file = SYL_INCLUDE_DIR . "/framework/Adm/Operation/{$classname}.php";
        if (!is_file($file)) {
            trigger_error("[SyL error] Invalid type (" . $form->getType() . ")", E_USER_ERROR);
        }
        include_once $file;
        $adm =& new $classname($form, $conn, $keys);
        return $adm;
    }
}

?>
