<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Context.php,v 1.11 2007/09/29 09:10:39 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ܾ󥯥饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Router.php';
/**
 * PHPեɥ饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Loader.php';

/**
 * ե졼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Context.php,v 1.11 2007/09/29 09:10:39 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Context
{
    /**
     * ѥ᡼
     * 
     * @access private
     * @var string
     */
    var $parameters = array();
    /**
     * ӥ塼
     * 
     * @access private
     * @var string
     */
    var $view_type = '';
    /**
     * ƥץ졼ȥե
     * 
     * @access private
     * @var string
     */
    var $template_file = '';
    /**
     * 쥤̾
     * 
     * @access private
     * @var string
     */
    var $layout_name = '';
    /**
     * ȥ饪֥
     * 
     * @access private
     * @var object
     */
    var $controller = null;
    /**
     * 롼֥
     * 
     * @access private
     * @var object
     */
    var $router = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param object ȥ饪֥
     */
    function SyL_Context(&$controller, &$data)
    {
        $this->controller =& $controller;
        $this->router     =& SyL_Router::factory($data, SYL_ROUTER_RULE);
    }

    /**
     * ƥȤ
     *
     * @access public
     * @param object ȥ饪֥
     * @param object ǡ֥
     */
    function &getInstance(&$controller, &$data)
    {
        static $singleton;
        if (!is_object($singleton)) {
            $class_name = 'SyL_Context' . ucfirst(SYL_ENV_TYPE);
            include_once SYL_INCLUDE_DIR . "/framework/Context/{$class_name}.php";
            // ҥ饹Υ󥹥
            $singleton = new $class_name($controller, $data);
        }
        return $singleton;
    }

    /**
     * ̾
     *
     * @access public
     * @return string ̾
     */
    function getActionName()
    {
        return is_object($this->router) ? $this->router->getActionName() : null;
    }

    /**
     * ǥ쥯ȥ
     *
     * @access public
     * @return string ǥ쥯ȥ
     */
    function getActionDir()
    {
        return $this->controller->getActionDir();
    }

    /**
     * ե
     *
     * @access public
     * @return string ե
     */
    function getActionFile()
    {
        return is_object($this->router) ? $this->router->getActionFile() : null;
    }

    /**
     * 饹̾
     *
     * @access public
     * @return string 饹̾
     */
    function getClassName()
    {
        return is_object($this->router) ? $this->router->getClassName() : null;
    }

    /**
     * ӥ塼פ򥻥å
     *
     * @access public
     * @return string ӥ塼
     */
    function setViewType($view_type)
    {
        $this->view_type = $view_type;
    }

    /**
     * ӥ塼פ
     *
     * @access public
     * @return string ӥ塼
     */
    function getViewType()
    {
        return $this->view_type;
    }

    /**
     * ƥץ졼ȥե򥻥å
     * 
     * @access public
     * @param string ƥץ졼ȥե
     */
    function setTemplateFile($template_file)
    {
        $this->template_file = $template_file;
    }

    /**
     * ƥץ졼ȥե򥻥åȡʥإѡ
     * ǻ
     * 
     * @access public
     * @param string ƥץ졼ȥե
     */
    function setTemplate($template)
    {
        $pos = strrpos($this->template_file, '.');
        if ($pos === false) {
            trigger_error("[SyL error] Template file extension not found ({$this->template_file})", E_USER_ERROR);
        }
        $ext = substr($this->template_file, $pos+1);
        $this->template_file = SyL_Loader::convertPath($template, $ext);
    }

    /**
     * ƥץ졼ȥǥ쥯ȥ
     * 
     * @access public
     * @return string ƥץ졼ȥǥ쥯ȥ
     */
    function getTemplateDir()
    {
        return $this->controller->getTemplateDir() . '/';
    }

    /**
     * ƥץ졼ȥե
     * 
     * @access public
     * @return string ƥץ졼ȥե
     */
    function getTemplateFile()
    {
        $template_dir  = $this->getTemplateDir();
        $template_file = $this->template_file;
        if (preg_match('/^(\\\\|\/)(.+)$/', $template_file, $matches)) {
            $template_file = $matches[2];
        }

        // ǥХå - ƥץ졼Ȥξ
        SyL_Loggers::debug("[Context] Template dir: {$template_dir} file: {$template_file}");

        // ƥץ졼ȥե¸ߥå
        if (!is_file($template_dir . $template_file)) {
            SyL_Loggers::warn("[Context] Template file not found dir: {$template_dir} file: {$template_file}");
            SyL_Response::forward404();
        }
        return $template_file;
    }

    /**
     * 쥤̾򥻥å
     *
     * @access public
     * @return string 쥤̾
     */
    function setLayoutName($layout_name)
    {
        $this->layout_name = $layout_name;
    }

    /**
     * 쥤̾
     *
     * @access public
     * @return string 쥤̾
     */
    function getLayoutName()
    {
        return $this->layout_name;
    }

    /**
     * ݡͥȥ֥Ȥ򥻥å
     * 
     * @access public
     * @param string ݡͥ̾
     * @return object ݡͥ
     */
    function &getComponent($name)
    {
        $container =& $this->controller->getContainer();
        return $container->getComponent($name);
    }

    /**
     * ѥ᡼򥻥å
     * 
     * @access public
     * @param string ѥ᡼̾
     * @param mixed ѥ᡼
     */
    function setParameter($name, $value)
    {
        $this->parameters[$name] = $value;
    }

    /**
     * ѥ᡼
     * 
     * @access public
     * @return array ѥ᡼
     */
    function &getParameters()
    {
        return $this->parameters;
    }

}

?>
