<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Js.php,v 1.4 2007/05/08 15:55:06 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ѥץѥƥ饹
 */
require_once SYL_INCLUDE_DIR . '/lib/Util/SyL_UtilProperty.php';

/**
 * JavaScriptϥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Js.php,v 1.4 2007/05/08 15:55:06 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Js extends SyL_UtilProperty
{
    /**
     * ݡȥե
     *
     * @access private
     * @var string
     */
    var $import = array();
    /**
     * ݡȥեΥѥ졼
     *
     * @access private
     * @var string
     */
    var $separater = ',';

    /**
     * ɽ⡼ɤ򥻥å
     *
     * @access public
     * @param string ɽ⡼
     */
    function import($import)
    {
        if ($import) {
            $this->import = array_merge($this->import, explode($this->separater, $import));
        }
    }

    /**
     * JavaScript
     *
     * @access public
     * @return string JavaScript
     */
    function getJs()
    {
        $js = '';
        if (!$this->import) {
            return $js;
        }

        // ѥ᡼̾Ѵ
        foreach ($this->gets() as $name => $value) {
            $$name = $value;
        }

        ob_start();
        foreach ($this->import as $mode) {
            $mode = array_map('ucfirst', explode('.', $mode));
            $cnt = count($mode);
            $prefix = 'SyL_';
            for ($i=0; $i<$cnt-1; $i++) {
                $prefix .= $mode[$i];
            }
            $mode[$cnt-1] = $prefix . $mode[$cnt-1] . '.js';
            $mode = implode('/', $mode);
            $file = SYL_INCLUDE_DIR . "/framework/JsClient/{$mode}";
            if (is_file($file)) {
                include_once $file;
            }
        }
        $js = ob_get_clean();

        // ǥȺ
        $js = preg_replace('/(\r\n|\r|\n)[ ]*/', "\n", $js);
        // Ⱥ
        //$js = preg_replace('/\/\*([^\/]*)\*\//s', "", $js);
        //$js = preg_replace('/\/\/([^(\r\n|\r|\n)]*)(\r\n|\r|\n)/', "", $js);

        return $js;
    }
}

?>
