<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSqlBuilder.php,v 1.1 2007/06/24 10:44:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * SQLơ֥륯饹
 */
require_once dirname(__FILE__) . '/SqlBuilder/SyL_DBSqlBuilderTable.php';
/**
 * SQLǡ饹
 */
require_once dirname(__FILE__) . '/SqlBuilder/SyL_DBSqlBuilderColumnData.php';

/**
 * SQLۥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSqlBuilder.php,v 1.1 2007/06/24 10:44:50 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBSqlBuilder
{
    /**
     * DBͥ󥪥֥
     *
     * @access protected
     * @var object
     */
    var $conn = null;
    /**
     * ơ֥̾
     *
     * @access protected
     * @var array
     */
    var $tables = array();
    /**
     * ̾
     *
     * @access private
     * @var array
     */
    var $column_datas = array();
    /**
     * 
     *
     * @access protected
     * @var array
     */
    var $wheres = array();
    /**
     * 
     *
     * @access private
     * @var array
     */
    var $order_bys = array();
    /**
     * 롼ײ
     *
     * @access private
     * @var array
     */
    var $group_bys = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param object DB֥
     */
    function SyL_DBSqlBuilder(&$conn)
    {
        $this->conn =& $conn;
    }

    /**
     * ơ֥륪֥Ȥ
     *
     * @access public
     * @param string ơ֥̾
     * @param string ơ֥̾
     * @return object ơ֥륪֥
     */
    function &getTable($name, $alias='')
    {
        $table =& new SyL_DBSqlBuilderTable($this->conn, $name, $alias);
        return $table;
    }

    /**
     * SQL˻Ѥơ֥򥻥åȤ
     *
     * @access public
     * @param object ơ֥륪֥
     */
    function addTable($table)
    {
        $this->tables[] = $table;
    }

    /**
     * DAOơ֥륹֥Ȥ򥻥åȤ
     *
     * @access public
     * @param object ơ֥륹֥
     */
    function addTableDao($dao_table, $alias='')
    {
        $table =& new SyL_DBSqlBuilderTable($this->conn, $dao_table->getTableName(), $alias);
        $this->addTable($table);
    }

    /**
     * SQL˻Ѥ륫򥻥åȤ
     *
     * @param object ४֥
     * @param mixed 
     */
    function addColumn($column, $value=null)
    {
        $this->column_datas[] = new SyL_DBSqlBuilderColumnData($column, $value, '=');
    }

    /**
     * whereӡ
     *
     * @access public
     * @param object ४֥
     * @param string 
     * @param bool true/=, false/<>
     * @param string AND or OR
     */
    function addWhereEqual($column, $value, $equal=true, $operator='AND')
    {
        $op = ($equal) ? '=' : '<>';
        $this->addWhere(new SyL_DBSqlBuilderColumnData($column, $value, $op), $operator);
    }

    /**
     * whereNULLӡ
     *
     * @access public
     * @param object ४֥
     * @param bool true/=, false/<>
     * @param string AND or OR
     */
    function addWhereNull($column, $equal=true, $operator='AND')
    {
        $op = ($equal) ? 'IS NULL' : 'IS NOT NULL';
        $this->addWhere(new SyL_DBSqlBuilderColumnData($column, null, $op), $operator);
    }

    /**
     * whereLIKEӡ
     *
     * @access public
     * @param object ४֥
     * @param string 
     * @param bool true/=, false/<>
     * @param string AND or OR
     */
    function addWhereLike($column, $value, $equal=true, $operator='AND')
    {
        $op = ($equal) ? 'LIKE' : 'NOT LIKE';
        $this->addWhere(new SyL_DBSqlBuilderColumnData($column, $value, $op), $operator);
    }

    /**
     * whereINӡ
     *
     * @access public
     * @param object ४֥
     * @param mixed 
     * @param bool true/=, false/<>
     * @param string AND or OR
     */
    function addWhereIn($column, $value, $equal=true, $operator='AND')
    {
        $op = ($equal) ? 'IN' : 'NOT IN';
        $this->addWhere(new SyL_DBSqlBuilderColumnData($column, $value, $op), $operator);
    }

    /**
     * where
     *
     * @access public
     * @param object ǡ֥
     * @param string AND or OR
     */
    function addWhere($where, $operator='AND')
    {
        switch (strtoupper($operator)) {
        case 'AND';
        case 'OR';
            break;
        default:
            trigger_error("Invalid SQL Operator ({$operator})", E_USER_ERROR);
        }

        $this->wheres[] = array($where, $operator);
    }

    /**
     * 롼ײɲä
     *
     * @access public
     * @param object ४֥
     */
    function addGroupBy($column)
    {
        $this->group_bys[] = $column;
    }

    /**
     * Ƚɲä
     *
     * @access public
     * @param object ४֥
     * @param string ASC or DESC
     */
    function addOrderBy($column, $sort='ASC')
    {
        switch (strtoupper($sort)) {
        case 'ASC';
        case 'DESC';
            break;
        default:
            trigger_error("Invalid SQL Sort Operator ({$sort})", E_USER_ERROR);
        }
        $this->order_bys[] = array($column, $sort);
    }

    /**
     * SQL(SELECT)ʸۤ
     *
     * @access public
     * @return string SQL(SELECT)ʸ
     */
    function getStatementSelect()
    {
        $column_datas = array();
        foreach ($this->column_datas as $column_data) {
            $column_datas[] = $column_data->column->getNameSelect();
        }

        $tables = array();
        foreach ($this->tables as $table) {
            $tables[] = $table->getNameFrom();
        }

        $wheres = array();
        foreach ($this->wheres as $where) {
            $wheres[] = $where[1] . ' ' . $where[0]->getFormat();
        }

        $group_bys = array();
        foreach ($this->group_bys as $column) {
            $group_bys[] = $column->getNameGroupBy();
        }

        $order_bys = array();
        foreach ($this->order_bys as $order_by) {
            $order_bys[] = $order_by[0]->getNameOrderBy() . ' ' . $order_by[1];
        }

        $sql  = "";
        $sql .= "SELECT ";
        $sql .=   implode(",", $column_datas) . " ";
        $sql .= "FROM ";
        $sql .=   implode(",", $tables) . " ";
        if (count($wheres) > 0) {
            $sql .= "WHERE ";
            $sql .=   "1=1 ";
            $sql .=   implode(" ", $wheres) . " ";
        }
        if (count($group_bys) > 0) {
            $sql .= "GROUP BY ";
            $sql .=   implode(",", $group_bys) . " ";
        }
        if (count($order_bys) > 0) {
            $sql .= "ORDER BY ";
            $sql .=   implode(",", $order_bys) . " ";
        }
        return $sql;
    }

    /**
     * SQL(INSERT)ʸۤ
     *
     * @access public
     * @return string SQL(INSERT)ʸ
     */
    function getStatementInsert()
    {
        $column_names  = array();
        $column_values = array();
        foreach ($this->column_datas as $column_data) {
            $column_names[]  = $column_data->column->getName();
            $column_values[] = $column_data->getQuoteData();
        }

        $table = $this->tables[0]->getName();

        $sql  = "";
        $sql .= "INSERT INTO {$table} (";
        $sql .=   implode(",", $column_names);
        $sql .= ") VALUES (";
        $sql .=   implode(",", $column_values);
        $sql .= ") ";

        return $sql;
    }

    /**
     * SQL(UPDATE)ʸۤ
     *
     * @access public
     * @return string SQL(INSERT)ʸ
     */
    function getStatementUpdate()
    {
        $column_values = array();
        foreach ($this->column_datas as $column_data) {
            $column_values[] = $column_data->column->getName() . ' = ' . $column_data->getQuoteData();
        }

        $table = $this->tables[0]->getName();

        $wheres = array();
        foreach ($this->wheres as $where) {
            $wheres[] = $where[1] . ' ' . $where[0]->getFormat();
        }

        $sql  = "";
        $sql .= "UPDATE {$table} SET ";
        $sql .=   implode(",", $column_values) . " ";
        if (count($wheres) > 0) {
            $sql .= "WHERE ";
            $sql .=   "1=1 ";
            $sql .=   implode(" ", $wheres) . " ";
        }

        return $sql;
    }

    /**
     * SQL(DELETE)ʸۤ
     *
     * @access public
     * @return string SQL(DELETE)ʸ
     */
    function getStatementDelete()
    {
        $table = $this->tables[0]->getName();

        $wheres = array();
        foreach ($this->wheres as $where) {
            $wheres[] = $where[1] . ' ' . $where[0]->getFormat();
        }

        $sql  = "";
        $sql .= "DELETE FROM {$table} ";
        if (count($wheres) > 0) {
            $sql .= "WHERE ";
            $sql .=   "1=1 ";
            $sql .=   implode(" ", $wheres) . " ";
        }

        return $sql;
    }
}

?>
