<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlElements.php,v 1.2 2007/04/30 13:15:57 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XMLĥ꡼쥯饹
 */
require_once 'SyL_XmlEntry.php';

/** 
 * XMLĥ꡼ǥ롼ץ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlElements.php,v 1.2 2007/04/30 13:15:57 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlElements extends SyL_XmlEntry
{
    /**
     * ǳǼ
     * 
     * @access private
     * @var array
     */
    var $entry = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string ̾
     * @param array °
     * @param string 
     * @param bool CDATAե饰
     */
    function SyL_XmlElement($name=null, $attributes=array(), $text='', $cdata=false)
    {
        parent::SyL_XmlEntry($name, $attributes, $text, $cdata);
    }

    /**
     * Ǥɲä
     *
     * @access public
     * @param object 
     */
    function add(&$entry)
    {
        $this->entry[] =& $entry;
    }

    /**
     * XMLǤ
     *
     * @access public
     * @param bool ԥե饰
     * @return string XML
     */
    function getTree($is_eol=false)
    {
        $element  = '';
        if ($this->comment !== null) {
            $element .= '<!--';
            $element .= htmlspecialchars($this->comment);
            $element .= '-->';
            if ($is_eol) {
                $element .= $this->eol;
            }
        }
        $element .= "<{$this->name}";
        foreach ($this->getAttributes() as $name => $value) {
            $element .= ' ' . $name . '="' . htmlspecialchars($value) . '"';
        }
        $element .= '>';

        if ($this->text !== null) {
            if ($this->cdata) {
                $element .= '<![CDATA[';
            }
            $element .= htmlspecialchars($this->text);
        } else {
            if ($is_eol) {
                $element .= $this->eol;
            }
        }

        foreach ($this->entry as $node) {
            $element .= $node->getTree($is_eol);
        }

        if ($this->cdata) {
            $element .= ']]>';
        }

        $element .= "</{$this->name}>";
        if ($is_eol) {
            $element .= $this->eol;
        }

        return $element;
    }
}

?>
