<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidatorCompare.php,v 1.4 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * Ӹڥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ValidationValidatorCompare.php,v 1.4 2007/04/30 13:15:56 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ValidationValidatorCompare extends SyL_ValidationValidator
{
    /**
     * ѥ᡼
     *
     * @access protected
     * @var array
     */
    var $parameters = array(
      'comp'        => '==',
      'comp_name'   => null,
      'comp_value'  => null,
      'comp_object' => null
    );

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string Хǡ
     * @param string 顼åΥեޥå
     * @param array ڥѥ᡼
     */
    function SyL_ValidationValidatorCompare($type, $error_message, $parameters=array())
    {
        parent::SyL_ValidationValidator($type, $error_message, $parameters);

        if (is_object($this->parameters['comp_object']) && is_subclass_of($this->parameters['comp_object'], 'SyL_FormElement')) {
            $this->parameters['comp_value'] = $this->parameters['comp_object']->getValue();
        }
    }

    /**
     * Ӹڽ¹Ԥ
     *
     * @access public
     * @param string о
     * @return bool true: 顼̵, false: 顼
     */
    function validate($value)
    {
        $compare = $this->parameters['comp'];
        $target  = $this->parameters['comp_value'];

        switch ($compare) {
        case '===': return ($value === $target);
        case '==':  return ($value == $target);
        case '!==': return ($value !== $target);
        case '!=':  return ($value != $target);
        case '<=':  return (strcmp($value, $target) <= 0);
        case '>=':  return (strcmp($value, $target) >= 0);
        case '<':   return (strcmp($value, $target) < 0);
        case '>':   return (strcmp($value, $target) > 0);
        default:    return false;
        }
    }

    /**
     * ӸڽJavaScript
     *
     * @access public
     * @return string JavaScriptå
     */
    function getJsCode()
    {
        $options = array();
        $options[] = "'compare': '{$this->parameters['comp']}'";
        $options[] = "'min_valids': '{$this->min_valids}'";
        $options[] = "'max_valids': '{$this->max_valids}'";
        if (is_object($this->parameters['comp_object']) && is_subclass_of($this->parameters['comp_object'], 'SyL_FormElement')) {
            $name = $this->parameters['comp_object']->getNames();
            $options[] = "'element': '{$name}'";
        } else {
            $options[] = "'value': '{$this->parameters['comp_value']}'";
        }

        $js  = '';
        $js .= 'if (!error_message) {' . "\n";
        $js .= '  var error_message_tmp = validation.isCompare(element_name, "' . $this->getErrorMessage() . '", {' . implode(',', $options) . '});' . "\n";
        $js .= '  if (error_message_tmp) {' . "\n";
        $js .= '    error_message = error_message_tmp;' . "\n";
        $js .= '  }' . "\n";
        $js .= '}' . "\n";

        return $js;
    }
}

?>
