<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlow.php,v 1.7 2007/11/19 14:18:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ADMбե९饹
 */
require_once 'SyL_AdmActionForm.php';
/**
 * DB饹
 */
require_once SYL_INCLUDE_DIR . '/lib/SyL_DB.php';
/**
 * ̥쥤䡼ǡ饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Adm.php';

/**
 * եδ쥯饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlow.php,v 1.7 2007/11/19 14:18:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_AdmFlow extends AppAction
{
    /**
     * ١URL
     *
     * @access protected
     * @var string
     */
    var $script_name = '';
    /**
     * PATH_INFO١ǥ쥯ȥ
     *
     * @access protected
     * @var string
     */
    var $pathinfo_base = '';
    /**
     * ڥ졼̾
     *
     * @access protected
     * @var string
     */
    var $opp_name = '';
    /**
     * ե९饹̾
     *
     * @access protected
     * @var string
     */
    var $classname = '';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_AdmFlow()
    {
        // ١URL
        $this->setScriptName();
        // PATH_INFO١ǥ쥯ȥ
        $this->setPathinfoBase();
    }

    /**
     * ADMե४֥Ȥ
     *
     * @access public
     * @return object ADMե४֥
     */
    function &getForm()
    {
        static $form = null;
        if ($form == null) {
            $form =& SyL_AdmActionForm::factory($this->classname);
            $form->setType($this->opp_name);
        }
        return $form;
    }

    /**
     * ١URL򥻥åȤ
     *
     * @access protected
     */
    function setScriptName()
    {
        $this->script_name = isset($_SERVER['SCRIPT_NAME']) ? $_SERVER['SCRIPT_NAME'] : '';
    }

    /**
     * PATH_INFO١ǥ쥯ȥ򥻥åȤ
     *
     * @access protected
     */
    function setPathinfoBase()
    {
        if (isset($_SERVER['PATH_INFO'])) {
            $this->pathinfo_base = $_SERVER['PATH_INFO'];
            if (substr($this->pathinfo_base, -1) != '/') {
                $this->pathinfo_base = dirname($_SERVER['PATH_INFO']) . '/';
            } else {
                if ($this->pathinfo_base == '') {
                    $this->pathinfo_base = '/';
                }
            }
        }
    }

    /**
     * ١URL
     *
     * @access protected
     * @return string ١URL
     */
    function getScriptName()
    {
        return $this->script_name;
    }

    /**
     * ڥ졼URL
     *
     * @access protected
     * @param string ڥ졼̾
     * @param string PATH_INFO
     * @return string ڥ졼URL
     */
    function getUrl($opp_name='', $pu='')
    {
        if (!$opp_name) {
            $opp_name = $this->opp_name;
        }
        if ($pu) {
            return "{$this->script_name}{$pu}";
        } else {
            return "{$this->script_name}{$this->pathinfo_base}{$opp_name}" . SYL_ROUTER_URL_EXT;
        }
    }

    /**
     * Ϣǡ 󥯤
     *
     * @access protected
     * @param string Ϣǡ
     * @return array Ϣǡ󥯡PREV, CURRENT, NEXT
     */
    function getLocations($u, $key='')
    {
        $pu = '';
        $cu = ($u ? $u : '');
        $nu = '';
        if ($cu) {
            if ($key) {
                $nu = $cu . "\t" . $this->pathinfo_base .'vew' . SYL_ROUTER_URL_EXT . '?' . $key;
            }
            $cus = explode("\t", $cu);
            $pu  = array_pop($cus);
            $cu  = implode("\t", $cus);
        } else {
            if ($key) {
                $nu = $this->pathinfo_base .'vew' . SYL_ROUTER_URL_EXT . '?' . $key;
            }
        }
        return array($pu, $cu, $nu);
    }
}

?>
