<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorJs.php,v 1.7 2007/11/19 14:18:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * JavaScriptϥ顼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ErrorJs.php,v 1.7 2007/11/19 14:18:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ErrorJs extends SyL_Error
{
    /**
     * Ķ̥顼
     * 
     * @access public
     * @param array 顼å
     * @param array 顼ȥ졼
     */
    function displayError($error_messages, $error_trace)
    {
        $error_message = '';
        if (ini_get('display_errors')) {
            // 顼å
            $error_message = implode($this->eol, $error_messages);
        }

        SyL_Response::setStatusHeader('500');
        $content_type = 'application/x-javascript; charset=' . SYL_ENCODE_INTERNAL;

        // JavaScirptƥĥ
        SyL_Response::setHeader('Content-Type', $content_type);
        $response =& SyL_Response::singleton();
        $response->display($error_message);
    }

    /**
     * ¸¾
     *
     * @access protected
     * @return string ¾
     */
    function extraLog()
    {
        $error_message  = '';
        if (isset($_SERVER['REQUEST_METHOD']))  $error_message .= 'REQUEST_METHOD: ' . $_SERVER['REQUEST_METHOD']  . $this->eol;
        if (isset($_SERVER['REQUEST_URI']))     $error_message .= 'REQUEST_URI: '    . $_SERVER['REQUEST_URI']     . $this->eol;
        if (isset($_SERVER['HTTP_REFERER']))    $error_message .= 'REFERRER: '       . $_SERVER['HTTP_REFERER']    . $this->eol;
        if (isset($_SERVER['HTTP_USER_AGENT'])) $error_message .= 'USER_AGENT: '     . $_SERVER['HTTP_USER_AGENT'] . $this->eol;
        $error_message .= 'GET : '  . print_r($_GET, true);
        $error_message .= 'POST : ' . print_r($_POST, true);
        return $error_message;
    }

}

?>
