<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2007 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewLayout.php,v 1.7 2007/11/19 14:18:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 쥤ȥӥ塼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewLayout.php,v 1.7 2007/11/19 14:18:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ViewLayout extends SyL_View
{
    /**
     * 쥤ե̾
     * 
     * @access private
     * @param string
     */
    var $layout_file_name = 'layouts.xml';
    /**
     * 쥤ե
     * 
     * @access private
     * @var array
     */
    var $config = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_ViewLayout(&$context, &$data)
    {
        parent::SyL_View($context, $data);

        $config_files = array();
        // 쥤
        $config_files[] = SYL_APP_CONFIG_DIR . "/{$this->layout_file_name}";

        $config =& SyL_Config::factory('layouts', $config_files, $context->controller);
        $config->parseXml();
        $this->config = $config->getConfig();

        // ƥĥפ򥻥å
        $this->setContentType('text/html; charset=' . SYL_ENCODE_INTERNAL);
    }

    /**
     * ƥץ졼ȥե
     * 
     * @access public
     * @return string ƥץ졼ȥե
     */
    function getTemplateFile()
    {
        return $this->config['file'];
    }

    /**
     * ѥ᡼
     * 
     * @access public
     * @return array ӥ塼Ϥѥ᡼
     */
    function &getActionValues()
    {
        $values =& parent::getActionValues();

        // 쥤
        if (isset($this->config['templates'])) {
            $values += $this->config['templates'];
        }
        if (isset($this->config['content']) && $this->config['content']) {
            $values[$this->config['content']] = $this->context->getTemplateFile();
        } else {
            SyL_Loggers::notice("Content context not found");
        }
        if (isset($this->config['params'])) {
            $values += $this->config['params'];
        }

        return $values;
    }
}

?>
