<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DataJs.php,v 1.3 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ꥯȥǡݻ饹
 */
require_once 'SyL_DataWeb.php';

/**
 * JavaScriptꥯȥǡݻ饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DataJs.php,v 1.3 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DataJs extends SyL_DataWeb
{
    /**
     * ϥѥ᡼򥻥å
     * 
     * @access protected
     */
    function initInputs()
    {
        // ѥ᡼
        $this->setInputs(($_SERVER['REQUEST_METHOD'] == 'POST') ? $_POST + $_GET : $_GET + $_POST);
        // ϥ󥳡ǥ󥰤Ѵ
        $this->apply('mb_convert_encoding', SYL_ENCODE_INTERNAL, SYL_ENCODE_JS);
        // ޥåݥȤͭȽ
        if (get_magic_quotes_gpc()) {
            $this->apply('stripslashes');
        }
        // ʸɥåɲ
        if (function_exists('mb_check_encoding')) {
            $this->applyCheckEncodingRecursive($this->input_parameters, SYL_ENCODE_INTERNAL);
        }
    }

    /**
     * ǸŪ˥ѥ᡼᥽å
     * 
     * @access public
     * @return array ѥ᡼
     */
    function finalOutputs()
    {
        // ϥ󥳡ǥ󥰤Ѵ
        $this->apply('mb_convert_encoding', SYL_ENCODE_JS, SYL_ENCODE_INTERNAL);
        $parameters = $this->gets();
        $this->deletes();
        return $parameters;
    }
}

?>
