<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowVew.php,v 1.7 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եδ쥯饹
 */
require_once SYL_INCLUDE_DIR . '/framework/Adm/SyL_AdmFlow.php';

/**
 * եܺɽ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowVew.php,v 1.7 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_AdmFlowVew extends SyL_AdmFlow
{
    /**
     * ڥ졼̾
     *
     * @access protected
     * @var string
     */
    var $opp_name = 'vew';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_AdmFlowVew()
    {
        parent::SyL_AdmFlow();
    }

    /**
     * ܺɽե
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȴ֥
     */
    function execute(&$data, &$context)
    {
        // ե
        $form =& $this->getForm();
        // 祭ѥ᡼̾
        $key_name = $form->getStructConfig('key_name');
        // ѥ᡼
        $key = $data->get($key_name);
        if (($key === null) || ($key === '')) {
            // Բ
            SyL_Response::redirect($this->getUrl('lst'));
        }

        // DB³
        $conn =& $context->getDB();
        // ADM֥Ⱥ
        $adm  =& SyL_Adm::factory($form, $conn, array($key));
        // ơ֥
        $adm->loadConfig();
        // å
        if (!$adm->isVew()) {
            // Բ
            SyL_Response::redirect($this->getUrl('lst'));
        }
        // ܺɽǡ
        $result = $adm->getRecord();
        if (!$result) {
            SyL_Response::redirect($this->getUrl('lst'));
        }
        // ¸ǡå
        $data->sets($result);
        // ǡ֥ȥå
        $form->registerInput($data);
        // ե๽
        $form->build();
        // ɽΤ
        $form->setReadOnly(true);

        // 祭ѥ᡼
        $key_value = $adm->getKeyQuery();

        // DB³λ
        $context->closeDB($conn);

        // Ϣǡ󥯤ѥ
        list($pu, $cu, $nu) = $this->getLocations($data->get('adm_u') , $key_name . '=' . urlencode($key));

        // եǥǡ
        $data->set('form', $form->getResultArray());
        // 祭ѥ᡼
        $data->set('key_name',  $key_name);
        $data->set('key_value', $key_value);
        $data->set('key_array', $adm->getKey());

        // ǧɽϢ
        $data->set('view_alert', $form->getStructConfig('view_alert'));
        // ʸϢ
        $data->set('title', $form->getStructConfig('title'));

        // URL
        $data->set('url_lst', $this->getUrl('lst'));
        $data->set('url_upd', $this->getUrl('upd'));
        $data->set('url_del', $this->getUrl('del'));
        $data->set('url_dir', dirname($this->getScriptName()));
        $data->set('url_lst_u', $this->getUrl('lst', $pu));

        $data->set('pu', $pu);
        $data->set('cu', $cu);
        $data->set('nu', $nu);

        // Խǽե饰
        $data->set('enable_upd', $adm->isUpd());
        // ǽե饰
        $data->set('enable_del', $adm->isDel());

        // Ϣ
        $data->set('related_links', $form->getRelatedLinks());
    }

}

?>
