<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RequestCookie.php,v 1.12 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * åݻ饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_RequestCookie.php,v 1.12 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_RequestCookie extends SyL_UtilProperty
{
    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_RequestCookie()
    {
        // ѥ᡼
        $this->parameters =& $_COOKIE;
        // ޥåݥȤͭȽ
        if (get_magic_quotes_gpc()) {
            $this->apply('stripslashes');
        }
    }

    /**
     * ѥ᡼򥻥å
     * 
     * @access public
     * @param string ѥ᡼̾
     * @param string ѥ᡼
     * @param int åͭ
     * @param string åͭȤѥ
     * @param string åͭʥɥᥤ
     * @param bool 奢HTTPS³ξˤΤߥåե饰
     */
    function set($name, $value, $expire=SYL_COOKIE_EXPIRE, $path=SYL_COOKIE_PATH, $domain=SYL_COOKIE_DOMAIN, $secure=SYL_COOKIE_SECURE)
    {
        // ñѴ y: ǯm: d: h: i: ʬs: 
        if (preg_match('/^(\d+)([ymdhis])$/', $expire, $match)) {
            $strtotime_format = '';
            switch ($match[2]) {
            case 'y': $strtotime_format = '+1 year';   break;
            case 'm': $strtotime_format = '+1 month';  break;
            case 'd': $strtotime_format = '+1 day';    break;
            case 'h': $strtotime_format = '+1 hour';   break;
            case 'i': $strtotime_format = '+1 minute'; break;
            case 's': $strtotime_format = '+1 second'; break;
            }
            if ($strtotime_format) {
                $expire = $match[1] * (strtotime($strtotime_format) - time());
            }
        }
        setcookie($name, $value, $expire, $path, $domain, $secure);
        parent::set($name, $value);
    }

    /**
     * ʣѥ᡼򥻥å
     * 
     * @access public
     * @param array ץѥƥ
     * @param int åͭ
     * @param string åͭȤѥ
     * @param string åͭʥɥᥤ
     * @param bool 奢HTTPS³ξˤΤߥåե饰
     */
    function sets($values, $expire=SYL_COOKIE_EXPIRE, $path=SYL_COOKIE_PATH, $domain=SYL_COOKIE_DOMAIN, $secure=SYL_COOKIE_SECURE)
    {
        foreach ($values as $name => $value) {
            $this->set($name, $value, $expire, $path, $domain, $secure);
        }
    }

    /**
     * ѥ᡼
     * 
     * @access public
     * @param string ѥ᡼̾
     * @param string åͭȤѥ
     * @param string åͭʥɥᥤ
     * @param ing 奢HTTPS³ξˤΤߥåե饰
     */
    function delete($name, $path=SYL_COOKIE_PATH, $domain=SYL_COOKIE_DOMAIN, $secure=SYL_COOKIE_SECURE)
    {
        setcookie($name, '', time()-3600, $path, $domain, $secure);
        parent::delete($name);
    }

    /**
     * ѥ᡼
     * 
     * @access public
     * @param string åͭȤѥ
     * @param string åͭʥɥᥤ
     * @param ing 奢HTTPS³ξˤΤߥåե饰
     */
    function deletes($path=SYL_COOKIE_PATH, $domain=SYL_COOKIE_DOMAIN, $secure=SYL_COOKIE_SECURE)
    {
        foreach ($this->parameters as $name => $value) {
            $this->delete($name, $path, $domain, $secure);
        }
        parent::deletes();
    }
}

?>
