<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDriverPear.php,v 1.3 2008/01/15 09:19:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * PEAR::DB饹
 */
require_once 'DB.php';

/**
 *  DB饹PEAR
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDriverPear.php,v 1.3 2008/01/15 09:19:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBDriverPear extends SyL_DB
{
    /**
     * DB³¹
     * 
     * @access public
     * @param string ǡ١̾
     * @param string 桼̾
     * @param string ѥ
     * @param string ۥ̾
     * @param string ݡֹ
     * @param bool ³Ū³Ԥ
     * @return boolean ³OK: true, ³NG: false
     */
    function openConnection($dbname, $user, $passwd, $host, $port, $persistent)
    {
        $dsn = $this->dbtype . '://';
        if ($user) {
            $dsn .= ($passwd) ? "{$user}:{$passwd}" : $user;
        }
        if ($host) {
            $dsn .= ($port) ? "@{$host}:{$port}" : "@{$host}";
        }
        if ($dbname) {
            $dsn  .= '/' . $dbname;
        }

        $this->connection =& DB::connect($dsn, $persistent);
        if (DB::isError($this->connection)) {
            $this->setErrorMessagePear($this->connection);
            $this->triggerError();
            return false;
        } else {
            $this->setDsnInfo($dbname, $user, $passwd, $host, $port, $persistent);
            return true;
        }
    }

    /**
     * DB³λ
     * 
     * @access public
     */
    function closeConnection()
    {
        if (is_object($this->connection)) {
            $this->connection->disconnect();
            $this->connection = null;
        }
    }

    /**
     * Ǹ˵ä顼å򥻥å
     *
     * @access public
     * @param object PEAR_Error֥
     */
    function setErrorMessagePear(&$error)
    {
        $error_message  = $error->getMessage() . ' (' . $error->getUserInfo() . ')';
        if ($error->getUserInfo()) {
            $error_message .= ' (' . $error->getUserInfo() . ')';
        }
        $this->setErrorMessage($error->getCode(), $error_message);
    }

    /**
     * ѥ᡼˥̵˽
     * 
     * @access public
     * @param string ˥оʸ
     * @return string ˥ʸ
     */
    function escape($parameter)
    {
        return $this->connection->escapeSimple($parameter);
    }

    /**
     * ѥ᡼ͤˤꥯȤʸ
     * ˥¹Ԥ
     *
     * @access public
     * @param string ʸ
     * @return string ȸʸ
     */
    function quote($value)
    {
        return $this->connection->quoteSmart($value);
    }

    /**
     * ȥ󥶥󳫻
     *
     * @access public
     */
    function beginTransaction()
    {
        parent::beginTransaction();
        $result = $this->connection->autoCommit(false);
        if (DB::isError($result)) {
            $this->setErrorMessagePear($result);
            return false;
        } else {
            return true;
        }
    }

    /**
     * ȥ󥶥˴
     *
     * @access public
     */
    function rollBack()
    {
        $result = $this->connection->rollback();
        parent::rollBack();
        if (DB::isError($result)) {
            $this->setErrorMessagePear($result);
            return false;
        } else {
            return true;
        }
    }

    /**
     * ȥ󥶥
     *
     * @access public
     */
    function commit()
    {
        $result = $this->connection->commit();
        parent::commit();
        if (DB::isError($result)) {
            $this->setErrorMessagePear($result);
            return false;
        } else {
            return true;
        }
    }

    /**
     * SQL¹Ԥ̼
     * 
     * SQLʸselectξ
     *   ¹Է̤꥽ȤƼ
     * SQLʸinsert, update, deleteξ
     *   ¹Է̱ƶ
     * SQLʸ嵭ʳξ
     *   ¹Ը塢true or falseֵ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed ¹Է̷ޤDB꥽
     * @return boolean ¹OK: true, ¹NG: false
     */
    function execRef($sql, &$result)
    {
        $this->convertEncoding($sql);
        parent::execRef($sql, $result);
    }

    /**
     * SQL¹ԤDB꥽
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: DB꥽, ¹NG: false
     */
    function execSelect($sql)
    {
        $result =& $this->connection->query($sql);
        if (!DB::isError($result)) {
            return $result;
        } else {
            $this->setErrorMessagePear($result);
            $this->triggerError();
            return false;
        }
    }

    /**
     * SQL¹Ԥ¹Է̱ƶ
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: ¹Է̱ƶ, ¹NG: false
     */
    function execUpdate($sql)
    {
        $result =& $this->connection->query($sql);
        if (!DB::isError($result)) {
            return $this->connection->affectedRows();
        } else {
            $this->setErrorMessagePear($result);
            $this->triggerError();
            return false;
        }
    }

    /**
     * SQL¹ԤΤ
     *
     * @access public
     * @param string SQLʸ
     * @return boolean ¹OK: true, ¹NG: false
     */
    function execNoReturn($sql)
    {
        $result =& $this->connection->query($sql);
        if (!DB::isError($result)) {
            return true;
        } else {
            $this->setErrorMessagePear($result);
            $this->triggerError();
            return false;
        }
    }

    /**
     * SQL¹Ԥ̥ǡ
     *
     * 3ѥ᡼'one'ξ
     *    ǽ1ʸȤƼ
     * 3ѥ᡼'record'ξ
     *    ǽ1쥳ɤȤƼ
     * 3ѥ᡼'all'ξ
     *    쥳ɤȤƼ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed  ¹Է̤
     * @param string ̼ե饰
     * @return boolean ¹OK: true, ¹NG: false
     */
    function queryRef($sql, &$data, $get='all')
    {
        // SQL¹
        $this->execRef($sql, $query);

        // Ƚ
        if (!is_object($query)) {
            $data = $query;
            return ($query !== false);
        }

        switch ($get) {
        case 'one':
            $result =& $query->fetchRow(DB_FETCHMODE_ORDERED);
            if (is_array($result) && (count($result) > 0)) {
                list($data) = $result;
            }
            break;
        case 'record':
            $result =& $query->fetchRow(DB_FETCHMODE_ASSOC);
            if ($result === null) {
                $data = array();
            } else {
                $data = $this->caseFieldName($result);
            }
            break;
        case 'all':
            $data = array();
            while ($result =& $query->fetchRow(DB_FETCHMODE_ASSOC)) {
                $data[] = $this->caseFieldName($result);
            }
            break;
        }
        $query->free();

        $this->convertDecoding($data);
        return true;
    }

    /**
     * SQL¹Ԥڡ˥ǡ
     *
     * @access public
     * @param string SQLʸ
     * @param array ¹Է̳Ǽ
     * @param object ڡ֥
     * @param int 1ڡɽ
     * @param int ɽоݥڡ 
     * @return bool ¹Է
     */
    function queryPageRef($sql, &$result, &$pager, $limit=20, $page=1)
    {
        // ڡ󥰥֥
        $pager = $this->getPager($limit, $page);
        // SQL
        $sql_count = "SELECT COUNT(*) FROM (" . $sql . ") AS SyL$";
        // SQL¹
        if (!$this->queryRef($sql_count, $record, 'one')) return false;
        $pager->setCountAll($record);

        // ǡSQL¹
        $query =& $this->connection->limitQuery($sql, $pager->getStartOffset(), $pager->getCount());
        if (DB::isError($query)) {
            $this->setErrorMessagePear($query);
            $this->triggerError();
            return false;
        }

        $result = array();
        while($row =& $query->fetchRow(DB_FETCHMODE_ASSOC)){
           $result[] = $row;
        }
    }
}

?>
