<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FilesystemDirectory.php,v 1.3 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ե륷ƥΥǥ쥯ȥꥯ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FilesystemDirectory.php,v 1.3 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_FilesystemDirectory extends SyL_Filesystem
{
    /**
     * Ǥ
     *
     * @access private
     * @var array
     */
    var $elements = array();
    /**
     * ȤΥȹ̾
     *
     * @access private
     * @var string
     */
    var $sort = '';
    /**
     * ȤΥȽ
     *
     * @access private
     * @var bool
     */
    var $asc = true;

    /**
     * ǥ쥯ȥȽ
     *
     * @access public
     * @return bool true: ǥ쥯ȥꡢfalse: ǥ쥯ȥʳ
     */
    function isDir()
    {
        return true;
    }

    /**
     * ʥǥ쥯ȥե륵ˤ
     *
     * @access protected
     * @return int 
     */
    function getSizeAll()
    {
        $this->createTree(null);
        $size = 0;
        foreach ($this->elements as $element) {
            $size = $element->getSizeAll();
        }
        return $size;
    }

    /**
     * ǥꥹȤ
     *
     * @access public
     * @param string ̾ name, size, mtime, owner
     * @param bool Ƚ true: 硢false: ߽
     * @return array ǥ֥ȡʤ
     */
    function getList($sort='name', $asc=true)
    {
        $dirs  = array();
        $files = array();
        foreach (array_keys($this->elements) as $i) {
            if ($this->elements[$i]->getType() == 'dir') {
                $dirs[] =& $this->elements[$i];
            } else {
                $files[] =& $this->elements[$i];
            }
        }

        // ȹ̾å
        $this->sort = $sort;
        // Ƚ祻å
        $this->asc = $asc;
        // ǥ쥯ȥΥ
        usort($dirs, array(&$this, 'sortList'));
        // եΥ
        usort($files, array(&$this, 'sortList'));

        return array_merge($dirs, $files);
    }

    /**
     * ǥꥹȤ
     *
     * @access private
     * @param string ̾ name, size, mtime, owner
     * @param bool Ƚ true: 硢false: ߽
     * @return array ǥ֥ȡʤ
     */
    function sortList($a, $b)
    {
        $result = 0;
        switch ($this->sort) {
        case 'name':
            $result = strcmp($a->getName(), $b->getName());
            break;
        case 'size':
            if (($a->getType() == 'file') && ($b->getType() == 'file')) {
                if ($a->getSize() < $b->getSize()) {
                    $result = -1;
                } else if ($a->getSize() > $b->getSize()) {
                    $result = 1;
                } else {
                    $result = 0;
                }
            }
            break;
        case 'mtime':
            if ($a->getStat('mtime') < $b->getStat('mtime')) {
                $result = -1;
            } else if ($a->getStat('mtime') > $b->getStat('mtime')) {
                $result = 1;
            } else {
                $result = 0;
            }
            break;
        case 'owner':
            $result = strcmp($a->getOwner(), $b->getOwner());
            break;
        }

        if ($this->asc) {
            return $result;
        } else {
            if ($result < 0) {
                return 1;
            } else if ($result > 0) {
                return -1;
            } else {
                return 0;
            }
        }
    }

    /**
     * ǥ쥯ȥ꤬¸ߤ뤫å
     *
     * @access protected
     * @return bool true: ¸ߤ롢false: ¸ߤʤ
     */
    function exists()
    {
        return is_dir($this->name);
    }

    /**
     * Ǥɲä
     *
     * @access public
     * @param object ǥ֥
     */
    function add($element)
    {
        $this->elements[] = $element;
    }

    /**
     * ǥ쥯ȥ
     *
     * @access public
     * @param string ǥ쥯ȥ̾Хѥ
     * @param int ⡼
     */
    function createDirectory($dir, $mode=0777)
    {
        $dirs = array();
        foreach (preg_split('/(\\\\|\/)/', $dir) as $dirname) {
            if (($dirname !== '') && ($dirname !== null)) {
                $dirs[] = $dirname;
            }
        }
        $this->createDirectoryRecursive($dirs, 0, $mode);
    }

    /**
     * ƵŪ˥ǥ쥯ȥ
     *
     * @access private
     * @param array ǥ쥯ȥ̾
     * @param int ȥǥ쥯ȥ
     * @param int ⡼
     */
    function createDirectoryRecursive($dirs, $current_dir, $mode)
    {
        if (isset($dirs[$current_dir])) {
            $dir = '';
            for ($i=0; $i<=$current_dir; $i++) {
                $dir .= $dirs[$i] . '/';
            }
            $dir = "{$this->name}/{$dir}";
            if (!is_dir($dir)) {
                mkdir($dir);
                chmod($dir, $mode);
            }
            $this->createDirectoryRecursive($dirs, $current_dir+1, $mode);
        }
    }

    /**
     * ǥ쥯ȥ
     *
     * @access public
     * @return bool true: OKfalse: 顼
     */
    function delete()
    {
        $this->createTree(null);
        foreach ($this->elements as $element) {
            if (!$element->delete()) {
                return false;
            }
        }
        if (rmdir($this->name)) {
            $this->clear();
            return true;
        } else {
            return false;
        }
    }

    /**
     * ǥ쥯ȥ곬ؤ
     *
     * @access public
     * @param int Ԥ糬
     */
    function createTree($limit_depth=1)
    {
        $this->clear();
        if ($dh = opendir($this->name)) {
            while (($name = readdir($dh)) !== false) {
                if (($name != '.') && ($name != '..')) {
                    $name = ($this->name == '/') ? "/{$name}" : "{$this->name}/{$name}";
                    $element =& SyL_Filesystem::factory($name);
                    if ($limit_depth === null) {
                        $element->createTree(null);
                    } else if ($limit_depth > 1) {
                        $element->createTree($limit_depth - 1);
                    }
                    $this->add($element);
                }
            }
            closedir($dh);
        }
    }

    /**
     * Ǥ򸡺
     *
     * @access public
     * @param string ե̾
     * @param int Ԥ糬
     */
    function searchTree($word, $limit_depth=1)
    {
        $result = array();
        if ($dh = opendir($this->name)) {
            while (($name = readdir($dh)) !== false) {
                if (($name != '.') && ($name != '..')) {
                    $name_tmp = $name;
                    $name = "{$this->name}/$name";
                    $element =& SyL_Filesystem::factory($name);
                   if ($limit_depth === null) {
                        $result = array_merge($result, $element->searchTree($word, null));
                    } else if ($limit_depth > 1) {
                        $result = array_merge($result, $element->searchTree($word, $limit_depth - 1));
                    }
                    if ((stristr($name_tmp, $word) !== false)) {
                        $result[] = $name;
                    }
                }
            }
            closedir($dh);
        }
        return $result;
    }

    /**
     * Ǥο֤
     *
     * @access public
     * @return int Ǥο
     */
    function getLength()
    {
        return count($this->elements);
    }

    /**
     * Ǿ
     *
     * @access public
     */
    function clear()
    {
        $this->elements = array();
    }
}

?>
