<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionSellingListRequest.php,v 1.2 2008/08/31 13:58:49 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan -  - ʥꥹѡ
 */
require_once 'SyL_WebServiceAuctionSellingListResponse.php';

/**
 * WEBӥꥯȥ饹Yahoo! Japan -  - ʥꥹѡ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 *  - ʥꥹ
 *   http://developer.yahoo.co.jp/auctions/rest/sellinglist/V1/sellinglist.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionSellingListRequest.php,v 1.2 2008/08/31 13:58:49 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceAuctionSellingListRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBӥСΥۥ̾
     *
     * @access protected
     * @var string
     */
    var $host = 'auctions.yahooapis.jp';
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/AuctionWebService/V1/SellingList';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceAuctionSellingListResponse';

    /**
     * ʼԤYahoo! JAPAN ID򥻥åȤ
     *
     * @access public
     * @param string ʼԤYahoo! JAPAN ID
     */
    function setSellerID($sellerID)
    {
        parent::set('sellerID', $sellerID);
    }

    /**
     * ʥꥹȤΥڡֹ򥻥åȤ
     *
     * @access public
     * @param int ʥꥹȤΥڡֹ
     */
    function setPage($page)
    {
        if (preg_match('/^\d+$/', $page) && ($page > 0)) {
            parent::set('page', $page);
        } else {
            trigger_error("[SyL error] Invalid `page' property ({$page}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ѥӥѲǽʾʤιʤ߻򥻥åȤ
     *
     * @access public
     * @param int ѥӥѲǽʾʤιʤ߻
     */
    function setEscrow($escrow)
    {
        if (preg_match('/^\d+$/', $escrow)) {
            parent::set('escrow', $escrow);
        } else {
            trigger_error("[SyL error] Invalid `escrow' property ({$escrow}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Yahoo!󤿤ѤѤǽʾʤιʤ߻򥻥åȤ
     *
     * @access public
     * @param int Yahoo!󤿤ѤѤǽʾʤιʤ߻
     */
    function setEasypayment($easypayment)
    {
        if (preg_match('/^\d+$/', $easypayment)) {
            parent::set('easypayment', $easypayment);
        } else {
            trigger_error("[SyL error] Invalid `easypayment' property ({$easypayment}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ξʤιʤ߻򥻥åȤ
     *
     * @access public
     * @param int ξʤιʤ߻
     */
    function setThumbnail($thumbnail)
    {
        if (preg_match('/^\d+$/', $thumbnail)) {
            parent::set('thumbnail', $thumbnail);
        } else {
            trigger_error("[SyL error] Invalid `thumbnail' property ({$thumbnail}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}

?>
