<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceNewsTopicsRequest.php,v 1.2 2008/08/31 13:58:49 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - ˥塼 - ȥԥåAPI
 */
require_once 'SyL_WebServiceNewsTopicsResponse.php';

/**
 * WEBӥꥯȥ饹Yahoo! Japan - ˥塼 - ȥԥåAPI
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ˥塼 - ȥԥåAPI
 *   http://developer.yahoo.co.jp/news/topics/V1/topics.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceNewsTopicsRequest.php,v 1.2 2008/08/31 13:58:49 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceNewsTopicsRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBӥСΥۥ̾
     *
     * @access protected
     * @var string
     */
    var $host = 'news.yahooapis.jp';
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/NewsWebService/V1/Topics';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceNewsTopicsResponse';

    /**
     * ȥԥå̾򥻥åȤ
     *
     * @access public
     * @param string ȥԥå̾
     */
    function setTopicname($topicname)
    {
        parent::set('topicname', $topicname);
    }

    /**
     * ꥫƥ򥻥åȤ
     *
     * @access public
     * @param string ꥫƥ
     */
    function setCategory($category)
    {
        switch ($category) {
        case 'domestic': //
        case 'world':    //
        case 'economy':  //к
        case 'entertainment': //󥿡ƥ
        case 'sports':   //ݡ
        case 'computer': //ԥ塼
        case 'science':  //
        case 'local':    //ϰ
            parent::set('category', $category);
            break;
        default:
            trigger_error("[SyL error] Invalid `category' property ({$category}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ɤ򥻥åȤ
     *
     * @access public
     * @param string 
     */
    function setWord($word)
    {
        parent::set('word', $word);
    }

    /**
     * Yahoo! JAPANȥåץڡؤηǺܤˤʤ߻򥻥åȤ
     *
     * @access public
     * @param bool Yahoo! JAPANȥåץڡؤηǺܤˤʤ߻
     */
    function setTopflg($topflg)
    {
        $topflg = ($topflg) ? '1' : '';
        parent::set('topflg', $topflg);
    }

    /**
     * ̵ͭ
     *
     * @access public
     * @param bool ̵ͭ
     */
    function setMidashiflg($midashiflg)
    {
        $midashiflg = ($midashiflg) ? '1' : '';
        parent::set('midashiflg', $midashiflg);
    }

    /**
     * Ϣȥԥåɽ
     *
     * @access public
     * @param bool Ϣȥԥåɽ
     */
    function setRelatedtopics($relatedtopics)
    {
        $relatedtopics = ($relatedtopics) ? '1' : '0';
        parent::set('relatedtopics', $relatedtopics);
    }

    /**
     * ϢȤɽ
     *
     * @access public
     * @param bool ϢȤɽ
     */
    function setRelatedsite($relatedsite)
    {
        $relatedsite = ($relatedsite) ? '1' : '0';
        parent::set('relatedsite', $relatedsite);
    }

    /**
     * ȹܤ򥻥åȤ
     *
     * @access public
     * @param string ȹ
     */
    function setSort($sort)
    {
        switch ($sort) {
        case 'pvindex':   // PVɸ
        case 'topicname': // ȥԥå̾
        case 'datetime':  // 
            parent::set('sort', $sort);
            break;
        default:
            trigger_error("[SyL error] Invalid `sort' property ({$sort}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Ȥν򥻥åȤ
     *
     * @access public
     * @param string Ȥν
     */
    function setOrder($order)
    {
        switch ($order) {
        case 'a': // 
        case 'd': // ߽
            parent::set('order', $order);
            break;
        default:
            trigger_error("[SyL error] Invalid `order' property ({$order}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ɽ򥻥åȤ
     *
     * @access public
     * @param int ɽ
     */
    function setNum($num)
    {
        if (preg_match('/^\d+$/', $num) && (($num >= 1) && ($num <= 30))) {
            parent::set('num', $num);
        } else {
            trigger_error("[SyL error] Invalid `num' property ({$num}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}

?>
