<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmOperationVew.php,v 1.5 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ̥쥤䡼ǡ饹 - ܺɽ
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmOperationVew.php,v 1.5 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_AdmOperationVew extends SyL_AdmOperation
{
    /**
     * 饹Υץѥƥơ֥ȴϢ
     *
     * @access public
     */
    function loadConfig()
    {
        parent::loadConfig();

        // ǡޥǡ
        $data_sources = $this->form->getDataSources();
        foreach ($data_sources as $name => $data_source) {
            // ơ֥륪֥ȼ
            $table = null;
            if (version_compare(PHP_VERSION, '5.0.0', '>=')) {
                $table = unserialize(serialize($this->tables[$data_source['alias']]));
            } else {
                $table = $this->tables[$data_source['alias']];
            }
            $table->initDataColumns();
            $table->addColumn($data_source['name']);
            $table->addColumn($data_source['value']);
            $table->addSort($data_source['name']);
            $table->addSort($data_source['value']);

            // ¸options
            $element_config = $this->form->getConfig($name);
            if (!isset($element_config['options'])) {
                $element_config['options'] = array();
            }
            foreach ($this->dao->select($table) as $values) {
                $column_name  = current($values);
                $column_value = next($values);
                $element_config['options'][$column_value] = $column_name;
            }
            $this->form->addConfig($name, $element_config);
        }
    }
}

?>
