<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigRouters.php,v 1.5 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 롼ƥեɤ߹९饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigRouters.php,v 1.5 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ConfigRouters extends SyL_Config
{
    /**
     * ե̾
     * 
     * @access private
     * @var string
     */
    var $config_file_name = 'routers.xml';

    /**
     * ե򥻥å
     *
     * @access protected
     */
    function setProjectConfigFiles()
    {
        $config = SYL_APP_CONFIG_DIR . "/{$this->config_file_name}";
        if (is_file($config)) {
            $this->file_names[] = $config;
        }
    }

    /**
     * XMLեβϽ
     *
     * @access public
     * @param bool åͭե饰
     */
    function parseXml($enable_cache=true)
    {
        if (count($this->file_names) > 0) {
            if (SYL_CACHE && $enable_cache) {
                // åѤ
                $key = SYL_APP_DIR;
                $cache =& $this->getCache($key);
                if ($cache) {
                    // å夬Ǥʤäʥå奪֥Ȥ
                    parent::parseXml();
                    $cache->write($this->config);
                }
            } else {
                // åѤʤ
                parent::parseXml();
            }
        }
    }

    /**
     * XMLǡƼϥɥ᥽å
     * С饤
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        // XMLϷ̤
        switch ($current_path) {
        case '/syl-routers/router':
            $enable_action   = true;
            $enable_template = true;
            if (isset($attribute['enableAction'])) {
                $enable_action = ($attribute['enableAction'] == 'true');
            }
            if (isset($attribute['enableTemplate'])) {
                $enable_template = ($attribute['enableTemplate'] == 'true');
            }

            if (!$enable_action && !$enable_template) {
                break;
            }

            $request_action = $attribute['requestAction'];

            $this->config[$request_action] = array();
            $this->config[$request_action]['forwardAction']   = isset($attribute['forwardAction'])   ? $attribute['forwardAction']   : '';
            $this->config[$request_action]['forwardTemplate'] = isset($attribute['forwardTemplate']) ? $attribute['forwardTemplate'] : '';
            $this->config[$request_action]['viewType']        = isset($attribute['viewType'])      ? $attribute['viewType']      : '';
            $this->config[$request_action]['layoutName']      = isset($attribute['layoutName'])    ? $attribute['layoutName']    : '';
            $this->config[$request_action]['enableAction']    = $enable_action;
            $this->config[$request_action]['enableTemplate']  = $enable_template;
            break;
        }
    }
}

?>
