<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Form.php,v 1.18 2008/05/21 17:22:47 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ڸ̥饹δ쥯饹
 */
require_once dirname(__FILE__) . '/Form/SyL_FormElement.php';
/**
 * ڥ饹
 */
require_once 'SyL_Validation.php';

/**
 * ե९饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Form.php,v 1.18 2008/05/21 17:22:47 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Form
{
    /**
     * ե̾
     * 
     * @access protected
     * @var string
     */
    var $name = 'syl_form';
    /**
     * ե°
     *
     * @access private
     * @var array
     */
    var $attributes = array();
    /**
     * եǤδܥ֥ȳǼ
     *
     * @access private
     * @var array
     */
    var $elements = array();
    /**
     * ѥ᡼ؿ
     *
     * @access private
     * @var mixed
     */
    var $input_callback = null;
    /**
     * ɽ
     *
     * @access private
     * @var array
     */
    var $results = array();
    /**
     * JavaScriptѥ᡼
     *
     * @access private
     * @var array
     */
    var $js_parameters = array(
      'func_name'   => '',
      'all_message' => true,
      'header'      => '',
      'footer'      => '',
      'error_callback' => null
    );

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string ꥯȥ
     * @param string ꥯȥ᥽å
     */
    function SyL_Form($action='', $method='POST')
    {
        $this->setAttribute('name',   $this->name);
        $this->setAttribute('id',     $this->name);
        $this->setAttribute('method', strtoupper($method));
        $this->setAttribute('action', $action ? $action : $_SERVER['PHP_SELF']);

        // եॹơ
        $this->results['javascript'] = '';
        $this->results['read_only']  = false;
        $this->results['error']      = false;
        // 顼å
        $this->results['error_message'] = array();
        // եǽ
        $this->results['elements'] = array();
        // ǥեȤΥѥ᡼ؿ
        $this->input_callback = array(&$this, 'getParameter');
    }

    /**
     * ̥եǥ֥Ȥμ
     *
     * @access public
     * @param string եǥ
     * @param string ե̾
     * @param string եɽ̾
     * @param array եǤradio, select, checkboxξΤߡ
     * @param array եǤɲ°
     */
    function &createElement($type, $element_name, $display_name, $options=array(), $attributes=array())
    {
        $value = call_user_func($this->input_callback, $element_name);
        $element =& SyL_FormElement::create($type, $element_name, $display_name, $value, $options, $attributes);
        if (is_a($element, 'SyL_FormElementGroup')) {
            $element->initGroup($this);
        }
        return $element;
    }

    /**
     * եǥ֥Ȥɲä
     *
     * @access public
     * @param object եǥ֥
     * @param object Хǡ󥪥֥
     */
    function addElement(&$element, $validation=null)
    {
        if ($validation != null) {
            $element->setValidators($validation);
        }
        if ($element->getType() == 'file') {
            $this->setAttribute('enctype', 'multipart/form-data');
        } else if ($element->getType() == 'group') {
            foreach ($element->elements as $element2) {
                if ($element2->getType() == 'file') {
                    $this->setAttribute('enctype', 'multipart/form-data');
                    break;
                }
            }
        }
        $element_name = $element->getName();
        // ǥ֥ȳǼ
        $this->elements[$element_name] =& $element;
        // 
        $this->results['elements'][$element_name] = array(
          'label'         => '',
          'html'          => '',
          'require'       => false,
          'error'         => false,
          'error_message' => '',
          'read_only'     => false
        );
    }

    /**
     * եǥ֥Ȥ
     *
     * @access public
     * @param string եHTML̾
     * @return object եǥ֥
     */
    function &getElement($element_name)
    {
        return $this->elements[$element_name];
    }

    /**
     * ѥ᡼ؿ򥻥å
     *
     * @access public
     * @param mixed ѥ᡼ؿ
     */
    function registerInputCallback($callback)
    {
        if (is_callable($callback)) {
            $this->input_callback = $callback;
        } else {
            trigger_error("[SyL error] Invalid callback parameter. Not function and method (" . var_export($input_callback) . ")", E_USER_ERROR);
        }
    }

    /**
     * ꥯȤͤ
     *
     * @access public
     * @param string ѥ᡼̾
     * @return mixed ѥ᡼
     */
    function getParameter($name)
    {
        switch ($this->getAttribute('method')) {
        case 'POST': return isset($_POST[$name]) ? $_POST[$name] : null;
        case 'GET':  return isset($_GET[$name])  ? $_GET[$name]  : null;
        default:     return null;
        }
    }

    /**
     * եॿ°򥻥å
     *
     * @access public
     * @param string եॿ°
     * @param string եॿ°
     */
    function setAttribute($key, $value)
    {
        $key = strtolower($key);
        $this->attributes[$key] = $value;
    }

    /**
     * եॿ°򥻥å
     *
     * @access public
     * @param string եॿ°
     * @return string եॿ°
     */
    function getAttribute($key)
    {
        $key = strtolower($key);
        return isset($this->attributes[$key]) ? $this->attributes[$key] : null;
    }

    /**
     * եॿ°
     *
     * @access public
     * @return string եॿ°
     */
    function getAttributes()
    {
        $attributes = array();
        foreach ($this->attributes as $name => $value) {
            $attributes[] = $name . '="' . $value . '"';
        }
        return implode(' ', $attributes);
    }

    /**
     * եɽ̾
     *
     * @access public
     * @param string ե̾
     * @return string եɽ̾
     */
    function getName($name)
    {
        return $this->elements[$name]->getDisplayName();
    }

    /**
     * եǤHTML
     *
     * @access public
     * @param string ե̾
     * @param bool true: html󥳡ɤԤfalse: html󥳡ɤԤʤ
     * @return string եǤHTML
     */
    function getHtml($name)
    {
        return $this->elements[$name]->getHtml();
    }

    /**
     * Ǥͤ
     *
     * @access public
     * @param string ե̾
     * @return mixed Ǥ
     */
    function getValue($name)
    {
        return $this->elements[$name]->getValue();
    }

    /**
     * ƤǤͤ
     *
     * @access public
     * @return array ƤǤ
     */
    function getValues()
    {
        $values = array();
        foreach (array_keys($this->elements) as $name) {
            $values[$name] = $this->getValue($name);
        }
        return $values;
    }

    /**
     * եǤɬܤȽꤹ
     *
     * @access public
     * @param string ե̾
     * @return bool true: ɬܡfalse: Ǥ
     */
    function isRequire($name)
    {
        if ($this->results['read_only']) {
            // ɽϡǤվ֤Ȥ
            return false;
        } else {
            return $this->elements[$name]->isRequire();
        }
    }

    /**
     * եǤɽΤߤȽꤹ
     *
     * @access public
     * @param string ե̾
     * @return bool true: ɬܡfalse: Ǥ
     */
    function isReadOnly($name)
    {
        return $this->elements[$name]->isReadOnly();
    }

    /**
     * եǤɽΤߤˤ뤫
     *
     * @access public
     * @param bool եǤɽΤߥե饰
     */
    function setReadOnly($read_only)
    {
        if (!is_bool($read_only)) {
            return;
        }
        foreach (array_keys($this->elements) as $key) {
            $this->elements[$key]->setReadOnly($read_only);
        }
        $this->results['read_only'] = $read_only;
    }

    /**
     * ƤǤθڤ¹Ԥ
     *
     * @access public
     * @return true: 顼ʤfalse: 顼
     */
    function validate()
    {
        $result = true;
        foreach (array_keys($this->elements) as $key) {
            if (!$this->elements[$key]->validate()) {
                $name          = $this->elements[$key]->getName();
                $error_message = $this->elements[$key]->getErrorMessage();
                $this->results['elements'][$name]['error'] = true;
                $this->results['elements'][$name]['error_message'] = $error_message;
                $this->results['error'] = true;
                $this->results['error_message'][] = $error_message;
                $result = false;
            }
        }
        return $result;
    }

    /**
     * եǤΥ顼Ƚꤹ
     *
     * @access public
     * @param string ե̾
     * @return bool true: ɬܡfalse: Ǥ
     */
    function isError($name='')
    {
        if ($name != '') {
            return $this->results['elements'][$name]['error'];
        } else {
            foreach ($this->results['elements'] as $name => $value) {
                if ($value['error']) {
                    return true;
                }
          }
          return false;
        }
    }

    /**
     * 顼å򥻥åȤ
     *
     * @access public
     * @param string ե̾
     * @param string 顼å
     */
    function setErrorMessage($name, $error_message)
    {
        $this->results['elements'][$name]['error'] = true;
        $this->results['elements'][$name]['error_message'] = $error_message;
        $this->results['error'] = true;
        $this->results['error_message'][] = $error_message;
    }

    /**
     * եǤΥ顼
     *
     * @access public
     * @param string ե̾
     * @return string 顼å
     */
    function getErrorMessage($name)
    {
        return $this->results['elements'][$name]['error_message'];
    }

    /**
     * եǤ顼
     *
     * @access public
     * @param string ե̾
     * @return array 顼å
     */
    function getErrorMessageAll()
    {
        return $this->results['error_message'];
    }

    /**
     * JavaScript
     *
     * @access public
     * @param string JavaScriptХǡ¹Դؿ̾
     * @param bool 顼åɽե饰
     */
    function useJs($func_name='sylFormCheck', $all_message=true)
    {
        $this->js_parameters['func_name'] = $func_name;
        $this->js_parameters['all_message'] = $all_message;
    }

    /**
     * JavaScript顼ΥХåؿ򥻥å
     *
     * @access public
     * @param string JavaScript顼ΥХåؿ
     */
    function setJsCustomErrorCallback($error_callback)
    {
        $this->js_parameters['error_callback'] = $error_callback;
    }

    /**
     * JavaScript顼åإåեå
     *
     * @access public
     * @param string JavaScript顼åإå
     * @param string JavaScript顼åեå
     */
    function setJsHeaderFooter($header='', $footer='')
    {
        $this->js_parameters['header'] = $header;
        $this->js_parameters['footer'] = $footer;
    }

    /**
     * JavaScriptϥå
     *
     * @access public
     * @return string JavaScriptϥå
     */
    function getJs()
    {
        $func_name = $this->js_parameters['func_name'];
        if (!$func_name) {
            return '';
        }

        $all_message = $this->js_parameters['all_message'] ? 'true' : 'false';

        // ƥå᥽å
        $funcs   = '';
        $checker = '';
        foreach (array_keys($this->elements) as $key) {
            $js = $this->elements[$key]->getJs($this->getAttribute('name'));
            if (count($js) == 2) {
              $funcs   .= '/* ' . $this->elements[$key]->getDisplayName() . ' check */' . "\n" . $js[0] . ';' . "\n";
              $checker .= $js[1] . "\n";
            }
        }

        // פʬʥȤʤɡ˺
        //$validation = preg_replace('/\/\*[^\/]*\*\//', '', $validation);
        //$validation = preg_replace('/^(\s*)\/\/(.*)$/m', '', $validation);
        //$validation = preg_replace('/^(\s+)(.*)$/m', '$2', $validation);

        $header = str_replace('"', '\\"', $this->js_parameters['header']);
        $footer = str_replace('"', '\\"', $this->js_parameters['footer']);

        return <<< JAVASCRIPT_CODE
<script type="text/javascript">
{$checker}
</script>
<script type="text/javascript">
var {$func_name}_submit = false;
function {$func_name}(form)
{
  if ({$func_name}_submit) {
    return false;
  }

  var errors = new SyL.Validation.Errors();
  errors.setCustomErrorCallback({$this->js_parameters['error_callback']});

{$funcs}

  if (errors.isError()) {
    errors.errorMessageHeader = "{$header}";
    errors.errorMessageHeader = "{$footer}";
    errors.setDisplayAllMessage({$all_message});
    errors.raiseErrorMessage();
    errors.focusElement(form);
    return false;
  } else {
    {$func_name}_submit = true;
    return true;
  }
}
</script>
JAVASCRIPT_CODE;
    }

    /**
     * եǤǼ
     *
     * @access public
     * @return array եǤ
     */
    function &getResultArray()
    {
        foreach (array_keys($this->elements) as $name) {
            $this->results['elements'][$name]['label']     = $this->getName($name);
            $this->results['elements'][$name]['html']      = $this->getHtml($name);
            $this->results['elements'][$name]['require']   = $this->isRequire($name);
            $this->results['elements'][$name]['read_only'] = $this->isReadOnly($name);
        }
        // եJSå
        $this->results['js_name'] = $this->js_parameters['func_name'];
        $this->results['js_code'] = $this->getJs();

        // եॿ°
        $this->results['attributes'] = $this->getAttributes();
        return $this->results;
    }
}

?>
