<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Template.php,v 1.1 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ѥץѥƥ饹
 */
require_once dirname(__FILE__) . '/Util/SyL_UtilProperty.php';

/** 
 * ƥץ졼ݥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Template.php,v 1.1 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Template extends SyL_UtilProperty
{
    /**
     * ƥץ졼ȥե
     *
     * @access protected
     * @var string
     */
    var $template_file = '';
    /**
     * ֥ƥץ졼
     *
     * @access protected
     * @var array
     */
    var $templates = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_Template($template_file)
    {
        $this->template_file = $template_file;
    }

    /**
     * ƥץ졼ȥ֥ȤΥ󥹥󥹤
     *
     * @static
     * @access public
     * @param string ƥץ졼ȥե
     * @param string ƥץ졼ȥ
     * @return object ƥץ졼ȥ֥
     */
    function &factory($template_file, $type='')
    {
        if (!$type) {
            switch (strtolower(pathinfo($template_file, PATHINFO_EXTENSION))) {
            case 'tpl':
            case 'html': $type = 'Smarty'; break;
            case 'xsl':  $type = 'Xslt';   break;
            default:     $type = 'Default';
            }
        }

        $class_name = 'SyL_Template' . ucfirst($type);
        include_once dirname(__FILE__) . "/Template/{$class_name}.php";
        $template = new $class_name($template_file);
        return $template;
    }

    /**
     * ֥ƥץ졼Ȥ򥻥å
     *
     * @access public
     * @param string ֥ƥץ졼̾
     * @param object ƥץ졼ȥ֥
     */
    function setTemplate($name, &$template)
    {
        $this->templates[$name] =& $template;
    }

    /**
     * ƥץ졼ȤŬѤ
     *
     * @access public
     * @return string ƥץ졼ŬѸǡ
     */
    function render()
    {
    }

    /**
     * ֥ƥץ졼ȤŬѤ
     *
     * @access public
     * @return array ƥץ졼ŬѸǡ
     */
    function renderChild()
    {
        $templates = array();
        foreach (array_keys($this->templates) as $name) {
            $this->templates[$name]->sets($this->templates[$name]->gets() + $this->gets());
            $templates[$name] = $this->templates[$name]->render();
        }
        return $templates;
    }
}

?>
