<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DataXmlrpc.php,v 1.8 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ꥯȥǡݻ饹
 */
require_once 'SyL_DataWeb.php';

/**
 * XMLRPCꥯȥѡ饹
 */
require_once SYL_INCLUDE_DIR . '/lib/Xml/Rpc/SyL_XmlRpcServerReader.php';

/**
 * XMLRPCꥯȥǡݻ饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DataXmlrpc.php,v 1.8 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DataXmlrpc extends SyL_DataWeb
{
    /**
     * ϥѥ᡼򥻥å
     * 
     * @access protected
     */
    function initInputs()
    {
        $xml = null;
        if (isset($_SERVER['REQUEST_METHOD']) && ($_SERVER['REQUEST_METHOD'] == 'POST')) {
            $xml = file_get_contents('php://input');
        }

        if (!$xml) {
            trigger_error("[SyL error] XMLRPC POST data not found.", E_USER_ERROR);
        }

        $reader =& new SyL_XmlRpcServerReader();
        $reader->setXmlEncode(SYL_ENCODE_XMLRPC);
        $reader->setClientEncode(SYL_ENCODE_INTERNAL);
        $reader->setData($xml);
        $reader->parseXml();

        $input_parameters = $reader->getArgs();
        array_unshift($input_parameters, $reader->getMethod());

        $this->setInputs($input_parameters);

        // ʸɥåɲ
        if (function_exists('mb_check_encoding')) {
            $this->applyCheckEncodingRecursive($this->input_parameters, SYL_ENCODE_INTERNAL);
        }
    }

    /**
     * ǸŪ˥ѥ᡼᥽å
     * 
     * @access public
     * @return array ѥ᡼
     */
    function finalOutputs()
    {
        $parameters = $this->gets(false);
        $this->deletes();
        return $parameters;
    }
}

?>
